/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityMultiblock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiblockManager<T extends SynchronizedData<T>> {
    private static Set<MultiblockManager> managers = new HashSet<MultiblockManager>();
    public String name;
    public Map<String, MultiblockCache<T>> inventories = new HashMap<String, MultiblockCache<T>>();

    public MultiblockManager(String s) {
        this.name = s;
        managers.add(this);
    }

    public MultiblockCache<T> pullInventory(World world, String id) {
        MultiblockCache<T> toReturn = this.inventories.get(id);
        for (Coord4D obj : this.inventories.get((Object)id).locations) {
            TileEntityMultiblock tileEntity = (TileEntityMultiblock)obj.getTileEntity((IBlockAccess)world);
            if (tileEntity == null) continue;
            tileEntity.cachedData = tileEntity.getNewCache();
            tileEntity.cachedID = null;
        }
        this.inventories.remove(id);
        return toReturn;
    }

    public String getUniqueInventoryID() {
        return UUID.randomUUID().toString();
    }

    public static void tick(World world) {
        for (MultiblockManager manager : managers) {
            manager.tickSelf(world);
        }
    }

    public void tickSelf(World world) {
        ArrayList<String> idsToKill = new ArrayList<String>();
        HashMap tilesToKill = new HashMap();
        for (Map.Entry<String, MultiblockCache<T>> entry : this.inventories.entrySet()) {
            String inventoryID = entry.getKey();
            for (Coord4D obj : entry.getValue().locations) {
                TileEntity tileEntity;
                if (obj.dimensionId != world.field_73011_w.field_76574_g || !obj.exists(world) || (tileEntity = obj.getTileEntity((IBlockAccess)world)) instanceof TileEntityMultiblock && ((TileEntityMultiblock)tileEntity).getManager() == this && (MultiblockManager.getStructureId((TileEntityMultiblock)tileEntity) == null || MultiblockManager.getStructureId((TileEntityMultiblock)tileEntity) == inventoryID)) continue;
                if (!tilesToKill.containsKey(inventoryID)) {
                    tilesToKill.put(inventoryID, new HashSet());
                }
                ((HashSet)tilesToKill.get(inventoryID)).add(obj);
            }
            if (!entry.getValue().locations.isEmpty()) continue;
            idsToKill.add(inventoryID);
        }
        for (Map.Entry<String, MultiblockCache<Object>> entry : tilesToKill.entrySet()) {
            for (Coord4D obj : (HashSet)((Object)entry.getValue())) {
                this.inventories.get((Object)entry.getKey()).locations.remove(obj);
            }
        }
        for (String string : idsToKill) {
            this.inventories.remove(string);
        }
    }

    public static String getStructureId(TileEntityMultiblock<?> tile) {
        return tile.structure != null ? ((SynchronizedData)tile.getSynchronizedData()).inventoryID : null;
    }

    public static boolean areEqual(TileEntity tile1, TileEntity tile2) {
        if (!(tile1 instanceof TileEntityMultiblock) || !(tile2 instanceof TileEntityMultiblock)) {
            return false;
        }
        return ((TileEntityMultiblock)tile1).getManager() == ((TileEntityMultiblock)tile2).getManager();
    }

    public void updateCache(TileEntityMultiblock<T> tile) {
        if (!this.inventories.containsKey(tile.cachedID)) {
            tile.cachedData.locations.add(Coord4D.get(tile));
            this.inventories.put(tile.cachedID, tile.cachedData);
            return;
        }
        this.inventories.get((Object)tile.cachedID).locations.add(Coord4D.get(tile));
    }

    public static void reset() {
        for (MultiblockManager manager : managers) {
            manager.inventories.clear();
        }
    }
}

