/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import codechicken.lib.math.MathHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderConfigurableMachine
extends TileEntitySpecialRenderer {
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private HashMap<ForgeDirection, HashMap<TransmissionType, MekanismRenderer.DisplayInteger>> cachedOverlays = new HashMap();

    public RenderConfigurableMachine() {
        this.field_147501_a = TileEntityRendererDispatcher.field_147556_a;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((ISideConfiguration)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(ISideConfiguration configurable, double x, double y, double z, float partialTick) {
        GL11.glPushMatrix();
        TileEntity tileEntity = (TileEntity)configurable;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        World world = this.mc.field_71439_g.field_70170_p;
        ItemStack itemStack = player.func_71045_bC();
        MovingObjectPosition pos = player.func_70614_a(8.0, 1.0f);
        if (pos != null && itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator && ((ItemConfigurator)itemStack.func_77973_b()).getState(itemStack).isConfigurating()) {
            SideData data;
            int xPos = MathHelper.floor_double((double)pos.field_72311_b);
            int yPos = MathHelper.floor_double((double)pos.field_72312_c);
            int zPos = MathHelper.floor_double((double)pos.field_72309_d);
            Coord4D obj = new Coord4D(xPos, yPos, zPos, tileEntity.func_145831_w().field_73011_w.field_76574_g);
            TransmissionType type = ((ItemConfigurator)itemStack.func_77973_b()).getState(itemStack).getTransmission();
            if (configurable.getConfig().supports(type) && xPos == tileEntity.field_145851_c && yPos == tileEntity.field_145848_d && zPos == tileEntity.field_145849_e && (data = configurable.getConfig().getOutput(type, pos.field_72310_e, configurable.getOrientation())) != TileComponentConfig.EMPTY) {
                this.push();
                MekanismRenderer.color(data.color, 0.6f);
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                int display = this.getOverlayDisplay((World)world, (ForgeDirection)ForgeDirection.getOrientation((int)pos.field_72310_e), (TransmissionType)type).display;
                GL11.glCallList((int)display);
                this.pop();
            }
        }
        GL11.glPopMatrix();
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, ForgeDirection side, TransmissionType type) {
        if (this.cachedOverlays.containsKey(side) && this.cachedOverlays.get(side).containsKey((Object)type)) {
            return this.cachedOverlays.get(side).get((Object)type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(MekanismRenderer.overlays.get((Object)type));
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(side)) {
            this.cachedOverlays.get(side).put(type, display);
        } else {
            HashMap<TransmissionType, MekanismRenderer.DisplayInteger> map = new HashMap<TransmissionType, MekanismRenderer.DisplayInteger>();
            map.put(type, display);
            this.cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        return display;
    }
}

