/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RotaryCondensentratorRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 12;

    public String getRecipeName() {
        return LangUtils.localize("nei.rotaryCondensentrator");
    }

    public String getOverlayIdentifier() {
        return "rotarycondensentrator";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiRotaryCondensentrator.png";
    }

    public Class getGuiClass() {
        return GuiRotaryCondensentrator.class;
    }

    public String getRecipeId() {
        return "mekanism.rotarycondensentrator";
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)71);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        if (recipe.type) {
            GuiDraw.drawTexturedModalRect((int)(64 - xOffset), (int)(39 - yOffset), (int)176, (int)123, (int)48, (int)8);
        } else {
            GuiDraw.drawTexturedModalRect((int)(64 - xOffset), (int)(39 - yOffset), (int)176, (int)115, (int)48, (int)8);
        }
        if (recipe.gasStack != null) {
            this.displayGauge(58, 26 - xOffset, 14 - yOffset, 176, 40, 58, null, recipe.gasStack);
        }
        if (recipe.fluidStack != null) {
            this.displayGauge(58, 134 - xOffset, 14 - yOffset, 176, 40, 58, recipe.fluidStack, null);
        }
        GuiDraw.drawString((String)(recipe.type ? LangUtils.localize("gui.condensentrating") : LangUtils.localize("gui.decondensentrating")), (int)(6 - xOffset), (int)(74 - yOffset), (int)0x404040, (boolean)false);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64 - xOffset, 39 - yOffset, 48, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Gas gas : GasRegistry.getRegisteredGasses()) {
                if (!gas.hasFluid()) continue;
                this.arecipes.add(new CachedIORecipe(new GasStack(gas, 1), new FluidStack(gas.getFluid(), 1), true));
                this.arecipes.add(new CachedIORecipe(new GasStack(gas, 1), new FluidStack(gas.getFluid(), 1), false));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            GasStack gas = (GasStack)results[0];
            if (gas.getGas().hasFluid()) {
                this.arecipes.add(new CachedIORecipe(new GasStack(gas.getGas(), 1), new FluidStack(gas.getGas().getFluid(), 1), false));
            }
        } else if (outputId.equals("fluid") && results.length == 1 && results[0] instanceof FluidStack) {
            FluidStack fluid = (FluidStack)results[0];
            Gas gas = GasRegistry.getGas(fluid.getFluid());
            if (gas != null) {
                this.arecipes.add(new CachedIORecipe(new GasStack(gas, 1), new FluidStack(fluid.getFluid(), 1), true));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            GasStack gas = (GasStack)ingredients[0];
            if (gas.getGas().hasFluid()) {
                this.arecipes.add(new CachedIORecipe(new GasStack(gas.getGas(), 1), new FluidStack(gas.getGas().getFluid(), 1), true));
            }
        } else if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            FluidStack fluid = (FluidStack)ingredients[0];
            Gas gas = GasRegistry.getGas(fluid.getFluid());
            if (gas != null) {
                this.arecipes.add(new CachedIORecipe(new GasStack(gas, 1), new FluidStack(fluid.getFluid(), 1), false));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).gasStack));
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeFluidStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidStack));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 18 && yAxis <= 76) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).gasStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 18 && yAxis <= 76) {
            fluid = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidStack;
        }
        if (gas != null ? (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(gas, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(gas, true)) : fluid != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(fluid, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 26 && xAxis <= 42 && yAxis >= 32 && yAxis <= 90) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).gasStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 32 && yAxis <= 90) {
            fluid = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidStack;
        }
        if (gas != null ? (button == 0 ? this.doGasLookup(gas, false) : button == 1 && this.doGasLookup(gas, true)) : fluid != null && (button == 0 ? this.doFluidLookup(fluid, false) : button == 1 && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public GasStack gasStack;
        public FluidStack fluidStack;
        public boolean type;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(GasStack gas, FluidStack fluid, boolean b) {
            super((TemplateRecipeHandler)RotaryCondensentratorRecipeHandler.this);
            this.gasStack = gas;
            this.fluidStack = fluid;
            this.type = b;
        }
    }
}

