/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import codechicken.lib.vec.Rectangle4i;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGraph
extends GuiElement {
    public int xPosition;
    public int yPosition;
    public int xSize;
    public int ySize;
    public int currentScale = 10;
    public boolean fixedScale = false;
    public List<Integer> graphData = new ArrayList<Integer>();
    public GraphDataHandler dataHandler;

    public GuiGraph(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY, GraphDataHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiGraph.png"), gui, def);
        this.xPosition = x;
        this.yPosition = y;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.dataHandler = handler;
    }

    public void enableFixedScale(int scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void addData(int data) {
        if (this.graphData.size() == this.xSize) {
            this.graphData.remove(0);
        }
        this.graphData.add(data);
        if (!this.fixedScale) {
            for (int i : this.graphData) {
                if (i <= this.currentScale) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    public Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new Rectangle4i(guiWidth + this.xPosition, guiHeight + this.yPosition, this.xSize, this.ySize);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiGraph.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.drawBlack(guiWidth, guiHeight);
        this.drawGraph(guiWidth, guiHeight);
        GuiGraph.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (xAxis >= this.xPosition && xAxis <= this.xPosition + this.xSize && yAxis >= this.yPosition && yAxis <= this.yPosition + this.ySize) {
            int height = this.ySize - (yAxis - this.yPosition);
            int scaled = (int)((double)height / (double)this.ySize * (double)this.currentScale);
            this.displayTooltip(this.dataHandler.getDataDisplay(scaled), xAxis, yAxis);
        }
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        int xDisplays = this.xSize / 10 + (this.xSize % 10 > 0 ? 1 : 0);
        int yDisplays = this.ySize / 10 + (this.ySize % 10 > 0 ? 1 : 0);
        for (int yIter = 0; yIter < yDisplays; ++yIter) {
            for (int xIter = 0; xIter < xDisplays; ++xIter) {
                int width = this.xSize % 10 > 0 && xIter == xDisplays - 1 ? this.xSize % 10 : 10;
                int height = this.ySize % 10 > 0 && yIter == yDisplays - 1 ? this.ySize % 10 : 10;
                this.guiObj.drawTexturedRect(guiWidth + this.xPosition + xIter * 10, guiHeight + this.yPosition + yIter * 10, 0, 0, width, height);
            }
        }
    }

    public void drawGraph(int guiWidth, int guiHeight) {
        for (int i = 0; i < this.graphData.size(); ++i) {
            int data = Math.min(this.currentScale, this.graphData.get(i));
            int relativeHeight = (int)((double)data / (double)this.currentScale * (double)this.ySize);
            this.guiObj.drawTexturedRect(guiWidth + this.xPosition + i, guiHeight + this.yPosition + (this.ySize - relativeHeight), 10, 0, 1, 1);
            int displays = (relativeHeight - 1) / 10 + ((relativeHeight - 1) % 10 > 0 ? 1 : 0);
            for (int iter = 0; iter < displays; ++iter) {
                MekanismRenderer.blendOn();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * ((float)i / (float)this.graphData.size())));
                int height = (relativeHeight - 1) % 10 > 0 && iter == displays - 1 ? (relativeHeight - 1) % 10 : 10;
                this.guiObj.drawTexturedRect(guiWidth + this.xPosition + i, guiHeight + this.yPosition + (this.ySize - iter * 10) - 10 + (10 - height), 11, 0, 1, height);
                MekanismRenderer.blendOff();
            }
        }
    }

    public static interface GraphDataHandler {
        public String getDataDisplay(int var1);
    }
}

