/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGauge;
import mekanism.common.Mekanism;
import mekanism.common.base.ITankManager;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.input.Keyboard;

public class GuiFluidGauge
extends GuiGauge<Fluid> {
    IFluidInfoHandler infoHandler;

    public GuiFluidGauge(IFluidInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiFluidGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiFluidGauge gauge = new GuiFluidGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.FLUID;
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            int index;
            TileEntityContainerBlock tile;
            ItemStack stack = GuiFluidGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (this.guiObj instanceof GuiMekanism && stack != null && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = ((GuiMekanism)this.guiObj).getTileEntity()) instanceof ITankManager && ((ITankManager)((Object)tile)).getTanks() != null && (index = Arrays.asList(((ITankManager)((Object)tile)).getTanks()).indexOf(this.infoHandler.getTank())) != -1) {
                if (button == 0 && Keyboard.isKeyDown((int)42)) {
                    button = 2;
                }
                Mekanism.packetHandler.sendToServer(new PacketDropperUse.DropperUseMessage(Coord4D.get(tile), button, index));
            }
        }
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (this.infoHandler.getTank().getFluid() == null || this.infoHandler.getTank().getCapacity() == 0) {
            return 0;
        }
        return this.infoHandler.getTank().getFluidAmount() * (this.height - 2) / this.infoHandler.getTank().getCapacity();
    }

    @Override
    public IIcon getIcon() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getIcon();
        }
        return this.infoHandler.getTank().getFluid().getFluid().getIcon();
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getLocalizedName(null);
        }
        return this.infoHandler.getTank().getFluid() != null ? LangUtils.localizeFluidStack(this.infoHandler.getTank().getFluid()) + ": " + this.infoHandler.getTank().getFluidAmount() + "mB" : LangUtils.localize("gui.empty");
    }

    public static interface IFluidInfoHandler {
        public FluidTank getTank();
    }
}

