/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.util;

public class UnitDisplayUtils {
    public static String getDisplay(double value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        String unitName = unit.name;
        String prefix = "";
        if (value < 0.0) {
            value = Math.abs(value);
            prefix = "-";
        }
        if (isShort) {
            unitName = unit.symbol;
        } else if (value > 1.0) {
            unitName = unit.getPlural();
        }
        if (value == 0.0) {
            return value + " " + unitName;
        }
        for (int i = 0; i < MeasurementUnit.values().length; ++i) {
            MeasurementUnit lowerMeasure = MeasurementUnit.values()[i];
            if (lowerMeasure.below(value) && lowerMeasure.ordinal() == 0) {
                return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            if (lowerMeasure.ordinal() + 1 >= MeasurementUnit.values().length) {
                return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            MeasurementUnit upperMeasure = MeasurementUnit.values()[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && lowerMeasure.value != value) continue;
            return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
        }
        return prefix + UnitDisplayUtils.roundDecimals(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplayShort(double value, ElectricUnit unit) {
        return UnitDisplayUtils.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(double value, ElectricUnit unit, int decimalPlaces) {
        return UnitDisplayUtils.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(double value, ElectricUnit unit, int decimalPlaces) {
        if (value > 1.0) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return UnitDisplayUtils.roundDecimals(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return UnitDisplayUtils.roundDecimals(value, decimalPlaces) + " " + unit.name;
    }

    public static String getDisplay(double T, TemperatureUnit unit, int decimalPlaces, boolean shift, boolean isShort) {
        String unitName = unit.name;
        String prefix = "";
        double value = unit.convertFromK(T, shift);
        if (value < 0.0) {
            value = Math.abs(value);
            prefix = "-";
        }
        if (isShort) {
            unitName = unit.symbol;
        }
        if (value == 0.0) {
            return value + (isShort ? "" : " ") + unitName;
        }
        for (int i = 0; i < MeasurementUnit.values().length; ++i) {
            MeasurementUnit lowerMeasure = MeasurementUnit.values()[i];
            if (lowerMeasure.below(value) && lowerMeasure.ordinal() == 0) {
                return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + (isShort ? "" : " ") + lowerMeasure.getName(isShort) + unitName;
            }
            if (lowerMeasure.ordinal() + 1 >= MeasurementUnit.values().length) {
                return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + (isShort ? "" : " ") + lowerMeasure.getName(isShort) + unitName;
            }
            MeasurementUnit upperMeasure = MeasurementUnit.values()[i + 1];
            if ((!lowerMeasure.above(value) || !upperMeasure.below(value)) && lowerMeasure.value != value) continue;
            return prefix + UnitDisplayUtils.roundDecimals(lowerMeasure.process(value), decimalPlaces) + (isShort ? "" : " ") + lowerMeasure.getName(isShort) + unitName;
        }
        return prefix + UnitDisplayUtils.roundDecimals(value, decimalPlaces) + (isShort ? "" : " ") + unitName;
    }

    public static String getDisplayShort(double value, TemperatureUnit unit) {
        return UnitDisplayUtils.getDisplayShort(value, true, unit);
    }

    public static String getDisplayShort(double value, boolean shift, TemperatureUnit unit) {
        return UnitDisplayUtils.getDisplayShort(value, unit, shift, 2);
    }

    public static String getDisplayShort(double value, TemperatureUnit unit, boolean shift, int decimalPlaces) {
        return UnitDisplayUtils.getDisplay(value, unit, decimalPlaces, shift, true);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return UnitDisplayUtils.roundDecimals(d, 2);
    }

    public static enum TempType {
        K,
        C,
        R,
        F,
        STP;

    }

    public static enum EnergyType {
        J,
        RF,
        EU,
        MJ;

    }

    public static enum MeasurementUnit {
        FEMTO("Femto", "f", 1.0E-15),
        PICO("Pico", "p", 1.0E-12),
        NANO("Nano", "n", 1.0E-9),
        MICRO("Micro", "u", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        BASE("", "", 1.0),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9),
        TERA("Tera", "T", 1.0E12),
        PETA("Peta", "P", 1.0E15),
        EXA("Exa", "E", 1.0E18),
        ZETTA("Zetta", "Z", 1.0E21),
        YOTTA("Yotta", "Y", 1.0E24);

        public String name;
        public String symbol;
        public double value;

        private MeasurementUnit(String s, String s1, double v) {
            this.name = s;
            this.symbol = s1;
            this.value = v;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double d) {
            return d / this.value;
        }

        public boolean above(double d) {
            return d > this.value;
        }

        public boolean below(double d) {
            return d < this.value;
        }
    }

    public static enum TemperatureUnit {
        KELVIN("Kelvin", "K", 0.0, 1.0),
        CELSIUS("Celsius", "\u00b0C", 273.15, 1.0),
        RANKINE("Rankine", "R", 0.0, 1.8),
        FAHRENHEIT("Fahrenheit", "\u00b0F", 459.67, 1.8),
        AMBIENT("Ambient", "+STP", 300.0, 1.0);

        public String name;
        public String symbol;
        public double zeroOffset;
        public double intervalSize;

        private TemperatureUnit(String s, String s1, double offset, double size) {
            this.name = s;
            this.symbol = s1;
            this.zeroOffset = offset;
            this.intervalSize = size;
        }

        public double convertFromK(double T, boolean shift) {
            return T * this.intervalSize - (shift ? this.zeroOffset : 0.0);
        }

        public double convertToK(double T, boolean shift) {
            return (T + (shift ? this.zeroOffset : 0.0)) / this.intervalSize;
        }
    }

    public static enum ElectricUnit {
        JOULES("Joule", "J"),
        REDSTONE_FLUX("Redstone Flux", "RF"),
        MINECRAFT_JOULES("Minecraft Joule", "MJ"),
        ELECTRICAL_UNITS("Electrical Unit", "EU");

        public String name;
        public String symbol;

        private ElectricUnit(String s, String s1) {
            this.name = s;
            this.symbol = s1;
        }

        public String getPlural() {
            return this == REDSTONE_FLUX ? this.name : this.name + "s";
        }
    }
}

