/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class GasTransmission {
    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity, Collection<ForgeDirection> sides) {
        IGasHandler[] acceptors = new IGasHandler[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : sides) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!(acceptor instanceof IGasHandler)) continue;
            acceptors[orientation.ordinal()] = (IGasHandler)acceptor;
        }
        return acceptors;
    }

    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        return GasTransmission.getConnectedAcceptors(tileEntity, Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
    }

    public static ITubeConnection[] getConnections(TileEntity tileEntity) {
        ITubeConnection[] connections = new ITubeConnection[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity connection = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!GasTransmission.canConnect(connection, orientation)) continue;
            connections[orientation.ordinal()] = (ITubeConnection)connection;
        }
        return connections;
    }

    public static boolean canConnect(TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ITubeConnection && (!(tileEntity instanceof ITransmitterTile) || TransmissionType.checkTransmissionType(((ITransmitterTile)tileEntity).getTransmitter(), TransmissionType.GAS)) && ((ITubeConnection)tileEntity).canTubeConnect(side.getOpposite());
    }

    public static GasStack removeGas(ItemStack itemStack, Gas type, int amount) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)itemStack.func_77973_b();
            if (type != null && item.getGas(itemStack) != null && item.getGas(itemStack).getGas() != type || !item.canProvideGas(itemStack, type)) {
                return null;
            }
            return item.removeGas(itemStack, amount);
        }
        return null;
    }

    public static int addGas(ItemStack itemStack, GasStack stack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem && ((IGasItem)itemStack.func_77973_b()).canReceiveGas(itemStack, stack.getGas())) {
            return ((IGasItem)itemStack.func_77973_b()).addGas(itemStack, stack.copy());
        }
        return 0;
    }

    public static int emit(GasStack stack, TileEntity from, Collection<ForgeDirection> sides) {
        int toSend;
        if (stack == null) {
            return 0;
        }
        ArrayList<IGasHandler> availableAcceptors = new ArrayList<IGasHandler>();
        IGasHandler[] possibleAcceptors = GasTransmission.getConnectedAcceptors(from, sides);
        for (int i = 0; i < possibleAcceptors.length; ++i) {
            IGasHandler handler = possibleAcceptors[i];
            if (handler == null || !handler.canReceiveGas(ForgeDirection.getOrientation((int)i).getOpposite(), stack.getGas())) continue;
            availableAcceptors.add(handler);
        }
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (IGasHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)Arrays.asList(possibleAcceptors).indexOf(acceptor)).getOpposite();
                toSend -= acceptor.receiveGas(dir, new GasStack(stack.getGas(), currentSending), true);
            }
        }
        return prevSending - toSend;
    }
}

