/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.upgrade.BinUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TileEntityBin
extends TileEntityMekanism
implements IConfigurable {
    public int addTicks = 0;
    private int delayTicks;
    private BinTier tier;
    private BinInventorySlot binSlot;

    public TileEntityBin(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    protected void presetVariables() {
        this.tier = Attribute.getTier(this.getBlockType(), BinTier.class);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.binSlot = BinInventorySlot.create(this, this.tier);
        builder.addSlot(this.binSlot);
        return builder.build();
    }

    public BinTier getTier() {
        return this.tier;
    }

    public int getItemCount() {
        return this.binSlot.getCount();
    }

    public BinInventorySlot getBinSlot() {
        return this.binSlot;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.addTicks = Math.max(0, this.addTicks - 1);
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            if (this.getActive()) {
                TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177977_b());
                TileTransitRequest request = new TileTransitRequest(this, Direction.DOWN);
                request.addItem(this.binSlot.getBottomStack(), 0);
                TransitRequest.TransitResponse response = tile instanceof TileEntityLogisticalTransporterBase ? ((TileEntityLogisticalTransporterBase)tile).getTransmitter().insert(this, request, null, true, 0) : request.addToInventory(tile, Direction.DOWN, false);
                if (!response.isEmpty() && this.tier != BinTier.CREATIVE) {
                    int sendingAmount = response.getSendingAmount();
                    MekanismUtils.logMismatchedStackSize(this.binSlot.shrinkStack(sendingAmount, Action.EXECUTE), sendingAmount);
                }
                this.delayTicks = 10;
            }
        } else {
            --this.delayTicks;
        }
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        this.setActive(!this.getActive());
        World world = this.func_145831_w();
        if (world != null) {
            world.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof BinUpgradeData) {
            BinUpgradeData data = (BinUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.binSlot.setStack(data.binSlot.getStack());
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    @Nonnull
    public BinUpgradeData getUpgradeData() {
        return new BinUpgradeData(this.redstone, this.getBinSlot());
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.field_145850_b != null && !this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("Item", (INBT)this.binSlot.serializeNBT());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setCompoundIfPresent(tag, "Item", nbt -> this.binSlot.deserializeNBT((CompoundNBT)nbt));
    }
}

