/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PressurizedReactionRecipeSerializer<RECIPE extends PressurizedReactionRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PressurizedReactionRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonElement ticks;
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient solidIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        JsonArray fluidInput = JSONUtils.func_151202_d((JsonObject)json, (String)"fluidInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"fluidInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"fluidInput");
        FluidStackIngredient fluidIngredient = FluidStackIngredient.deserialize((JsonElement)fluidInput);
        JsonArray gasInput = JSONUtils.func_151202_d((JsonObject)json, (String)"gasInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"gasInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"gasInput");
        GasStackIngredient gasIngredient = GasStackIngredient.deserialize((JsonElement)gasInput);
        FloatingLong energyRequired = FloatingLong.ZERO;
        if (json.has("energyRequired")) {
            energyRequired = SerializerHelper.getFloatingLong(json, "energyRequired");
        }
        if (!JSONUtils.func_188175_b((JsonElement)(ticks = json.get("duration")))) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        int duration = ticks.getAsJsonPrimitive().getAsInt();
        if (duration <= 0) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        ItemStack itemOutput = ItemStack.field_190927_a;
        GasStack gasOutput = GasStack.EMPTY;
        if (json.has("itemOutput")) {
            itemOutput = SerializerHelper.getItemStack(json, "itemOutput");
            if (itemOutput.func_190926_b()) {
                throw new JsonSyntaxException("Reaction chamber item output must not be empty, if it is defined.");
            }
            if (json.has("gasOutput") && (gasOutput = SerializerHelper.getGasStack(json, "gasOutput")).isEmpty()) {
                throw new JsonSyntaxException("Reaction chamber gas output must not be empty, if it is defined.");
            }
        } else {
            gasOutput = SerializerHelper.getGasStack(json, "gasOutput");
            if (gasOutput.isEmpty()) {
                throw new JsonSyntaxException("Reaction chamber gas output must not be empty, if there is no item output.");
            }
        }
        return this.factory.create(recipeId, solidIngredient, fluidIngredient, gasIngredient, energyRequired, duration, itemOutput, gasOutput);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient inputSolid = ItemStackIngredient.read(buffer);
            FluidStackIngredient inputFluid = FluidStackIngredient.read(buffer);
            GasStackIngredient inputGas = GasStackIngredient.read(buffer);
            FloatingLong energyRequired = FloatingLong.readFromBuffer(buffer);
            int duration = buffer.func_150792_a();
            ItemStack outputItem = buffer.func_150791_c();
            GasStack outputGas = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, inputSolid, inputFluid, inputGas, energyRequired, duration, outputItem, outputGas);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading pressurized reaction recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((PressurizedReactionRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing pressurized reaction recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends PressurizedReactionRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, FluidStackIngredient var3, GasStackIngredient var4, FloatingLong var5, int var6, ItemStack var7, GasStack var8);
    }
}

