/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateTile {
    private final CompoundNBT updateTag;
    private final BlockPos pos;

    public PacketUpdateTile(TileEntityUpdateable tile) {
        this(tile.func_174877_v(), tile.getReducedUpdateTag());
    }

    private PacketUpdateTile(BlockPos pos, CompoundNBT updateTag) {
        this.pos = pos;
        this.updateTag = updateTag;
    }

    public static void handle(PacketUpdateTile message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                TileEntityUpdateable tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (IBlockReader)world, message.pos, true);
                if (tile == null) {
                    Mekanism.logger.info("Update tile packet received for position: {} in world: {}, but no valid tile was found.", (Object)message.pos, (Object)world.func_234923_W_().func_240901_a_());
                } else {
                    tile.handleUpdatePacket(message.updateTag);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateTile pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_150786_a(pkt.updateTag);
    }

    public static PacketUpdateTile decode(PacketBuffer buf) {
        return new PacketUpdateTile(buf.func_179259_c(), buf.func_150793_b());
    }
}

