/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Supplier;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTransporterUpdate {
    private final boolean isDiversion;
    private final boolean isSync;
    private final BlockPos pos;
    private LogisticalTransporterBase transporter;
    private DiversionTransporter.DiversionControl[] modes;
    private int stackId;
    private TransporterStack stack;
    private Int2ObjectMap<TransporterStack> updates;
    private IntSet deletes;

    public PacketTransporterUpdate(LogisticalTransporterBase tile, int stackId, TransporterStack stack) {
        this(tile, true);
        this.stackId = stackId;
        this.stack = stack;
    }

    public PacketTransporterUpdate(LogisticalTransporterBase tile, Int2ObjectMap<TransporterStack> updates, IntSet deletes) {
        this(tile, false);
        this.updates = updates;
        this.deletes = deletes;
    }

    private PacketTransporterUpdate(LogisticalTransporterBase transporter, boolean isSync) {
        this.isSync = isSync;
        this.pos = transporter.getTilePos();
        this.isDiversion = transporter instanceof DiversionTransporter;
        if (this.isDiversion) {
            this.modes = ((DiversionTransporter)transporter).modes;
        }
        this.transporter = transporter;
    }

    private PacketTransporterUpdate(BlockPos pos, boolean isSync, boolean isDiversion) {
        this.pos = pos;
        this.isSync = isSync;
        this.isDiversion = isDiversion;
    }

    public static void handle(PacketTransporterUpdate message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, message.pos);
            if (tile != null) {
                LogisticalTransporterBase transporter = tile.getTransmitter();
                if (message.isSync) {
                    transporter.addStack(message.stackId, message.stack);
                } else {
                    for (Int2ObjectMap.Entry entry : message.updates.int2ObjectEntrySet()) {
                        transporter.addStack(entry.getIntKey(), (TransporterStack)entry.getValue());
                    }
                    ObjectIterator objectIterator = message.deletes.iterator();
                    while (objectIterator.hasNext()) {
                        int toDelete = (Integer)objectIterator.next();
                        transporter.deleteStack(toDelete);
                    }
                }
                if (message.isDiversion && transporter instanceof DiversionTransporter) {
                    System.arraycopy(message.modes, 0, ((DiversionTransporter)transporter).modes, 0, message.modes.length);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketTransporterUpdate pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeBoolean(pkt.isSync);
        buf.writeBoolean(pkt.isDiversion);
        if (pkt.isSync) {
            buf.func_150787_b(pkt.stackId);
            pkt.stack.write(pkt.transporter, buf);
        } else {
            buf.func_150787_b(pkt.updates.size());
            for (Int2ObjectMap.Entry entry : pkt.updates.int2ObjectEntrySet()) {
                buf.func_150787_b(entry.getIntKey());
                ((TransporterStack)entry.getValue()).write(pkt.transporter, buf);
            }
            buf.func_150787_b(pkt.deletes.size());
            ObjectIterator objectIterator = pkt.deletes.iterator();
            while (objectIterator.hasNext()) {
                int toDelete = (Integer)objectIterator.next();
                buf.func_150787_b(toDelete);
            }
        }
        if (pkt.isDiversion) {
            for (int i = 0; i < pkt.modes.length; ++i) {
                buf.func_179249_a((Enum)pkt.modes[i]);
            }
        }
    }

    public static PacketTransporterUpdate decode(PacketBuffer buf) {
        PacketTransporterUpdate packet = new PacketTransporterUpdate(buf.func_179259_c(), buf.readBoolean(), buf.readBoolean());
        if (packet.isSync) {
            packet.stackId = buf.func_150792_a();
            packet.stack = TransporterStack.readFromPacket(buf);
        } else {
            int updatesSize = buf.func_150792_a();
            packet.updates = new Int2ObjectOpenHashMap(updatesSize);
            for (int i = 0; i < updatesSize; ++i) {
                packet.updates.put(buf.func_150792_a(), (Object)TransporterStack.readFromPacket(buf));
            }
            int deletesSize = buf.func_150792_a();
            packet.deletes = new IntOpenHashSet(deletesSize);
            for (int i = 0; i < deletesSize; ++i) {
                packet.deletes.add(buf.func_150792_a());
            }
        }
        if (packet.isDiversion) {
            packet.modes = new DiversionTransporter.DiversionControl[EnumUtils.DIRECTIONS.length];
            for (int i = 0; i < packet.modes.length; ++i) {
                packet.modes[i] = (DiversionTransporter.DiversionControl)buf.func_179257_a(DiversionTransporter.DiversionControl.class);
            }
        }
        return packet;
    }
}

