/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketQIOItemViewerSlotInteract {
    private final Type type;
    private final UUID typeUUID;
    private final int count;

    private PacketQIOItemViewerSlotInteract(Type type, UUID typeUUID, int count) {
        this.type = type;
        this.typeUUID = typeUUID;
        this.count = count;
    }

    public static PacketQIOItemViewerSlotInteract take(UUID typeUUID, int count) {
        return new PacketQIOItemViewerSlotInteract(Type.TAKE, typeUUID, count);
    }

    public static PacketQIOItemViewerSlotInteract put(int count) {
        return new PacketQIOItemViewerSlotInteract(Type.PUT, null, count);
    }

    public static PacketQIOItemViewerSlotInteract shiftTake(UUID typeUUID) {
        return new PacketQIOItemViewerSlotInteract(Type.SHIFT_TAKE, typeUUID, 0);
    }

    public static void handle(PacketQIOItemViewerSlotInteract message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && player.field_71070_bA instanceof QIOItemViewerContainer) {
                QIOItemViewerContainer container = (QIOItemViewerContainer)player.field_71070_bA;
                QIOFrequency freq = container.getFrequency();
                ItemStack curStack = player.field_71071_by.func_70445_o();
                if (freq != null) {
                    if (message.type == Type.TAKE) {
                        ItemStack ret = freq.removeByType(freq.getTypeByUUID(message.typeUUID), message.count);
                        if (curStack.func_190926_b()) {
                            player.field_71071_by.func_70437_b(ret);
                        } else if (InventoryUtils.areItemsStackable(ret, curStack)) {
                            curStack.func_190917_f(ret.func_190916_E());
                        }
                        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
                    } else if (message.type == Type.SHIFT_TAKE) {
                        ItemStack ret;
                        ItemStack remainder;
                        HashedItem itemType = freq.getTypeByUUID(message.typeUUID);
                        if (itemType != null && !(remainder = container.insertIntoPlayerInventory(ret = freq.removeByType(itemType, itemType.getStack().func_77976_d()))).func_190926_b() && !(remainder = freq.addItem(remainder)).func_190926_b()) {
                            Mekanism.logger.error("QIO shift-click transfer resulted in lost items ({}). This shouldn't happen!", (Object)remainder);
                        }
                    } else if (message.type == Type.PUT) {
                        if (!curStack.func_190926_b()) {
                            ItemStack rejects = freq.addItem(StackUtils.size(curStack, Math.min(message.count, curStack.func_190916_E())));
                            ItemStack newStack = StackUtils.size(curStack, curStack.func_190916_E() - (message.count - rejects.func_190916_E()));
                            player.field_71071_by.func_70437_b(newStack);
                        }
                        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketQIOItemViewerSlotInteract pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        switch (pkt.type) {
            case TAKE: {
                buf.func_179252_a(pkt.typeUUID);
                buf.func_150787_b(pkt.count);
                break;
            }
            case SHIFT_TAKE: {
                buf.func_179252_a(pkt.typeUUID);
                break;
            }
            case PUT: {
                buf.func_150787_b(pkt.count);
            }
        }
    }

    public static PacketQIOItemViewerSlotInteract decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        UUID typeUUID = null;
        int count = 0;
        switch (type) {
            case TAKE: {
                typeUUID = buf.func_179253_g();
                count = buf.func_150792_a();
                break;
            }
            case SHIFT_TAKE: {
                typeUUID = buf.func_179253_g();
                break;
            }
            case PUT: {
                count = buf.func_150792_a();
            }
        }
        return new PacketQIOItemViewerSlotInteract(type, typeUUID, count);
    }

    public static enum Type {
        TAKE,
        SHIFT_TAKE,
        PUT;

    }
}

