/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.content.gear.Modules;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModule
extends Item
implements IModuleItem {
    private final Modules.ModuleData<?> moduleData;

    public ItemModule(Modules.ModuleData<?> moduleData, Item.Properties properties) {
        super(properties.func_200917_a(moduleData.getMaxStackSize()).func_208103_a(Rarity.UNCOMMON));
        moduleData.setStack(this);
        this.moduleData = moduleData;
    }

    @Override
    public Modules.ModuleData<?> getModuleData() {
        return this.moduleData;
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return this.moduleData.getRarity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.detailsKey)) {
            for (Item item : Modules.getSupported(this.getModuleData())) {
                tooltip.add(item.func_200295_i(new ItemStack((IItemProvider)item)));
            }
        } else {
            tooltip.add(this.moduleData.getDescription());
            tooltip.add((ITextComponent)MekanismLang.MODULE_STACKABLE.translateColored(EnumColor.GRAY, EnumColor.AQUA, this.moduleData.getMaxStackSize()));
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_SUPPORTED_ITEMS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    @Nonnull
    public String func_77658_a() {
        return this.moduleData.getTranslationKey();
    }
}

