/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IFluidHandlerSlot
extends IInventorySlot {
    public IExtendedFluidTank getFluidTank();

    public boolean isDraining();

    public boolean isFilling();

    public void setDraining(boolean var1);

    public void setFilling(boolean var1);

    default public void handleTank(IInventorySlot outputSlot, IFluidContainerManager.ContainerEditMode editMode) {
        if (!this.isEmpty()) {
            ItemStack stack;
            Optional cap;
            if (editMode == IFluidContainerManager.ContainerEditMode.FILL) {
                this.drainTank(outputSlot);
            } else if (editMode == IFluidContainerManager.ContainerEditMode.EMPTY) {
                this.fillTank(outputSlot);
            } else if (editMode == IFluidContainerManager.ContainerEditMode.BOTH && (cap = FluidUtil.getFluidHandler((ItemStack)((stack = this.getStack()).func_190916_E() > 1 ? StackUtils.size(stack, 1) : stack)).resolve()).isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean hasEmpty = false;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (this.isDraining() || this.getFluidTank().insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    this.fillTank(outputSlot);
                    return;
                }
                if (this.isFilling()) {
                    if (this.moveItem(outputSlot, stack)) {
                        this.setFilling(false);
                    }
                } else if (this.getFluidTank().isEmpty() && hasEmpty || this.isDraining() || fluidHandlerItem.fill(this.getFluidTank().getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.drainTank(outputSlot);
                }
            }
        }
    }

    default public void fillTank(IInventorySlot outputSlot) {
        block4: {
            int itemTanks;
            IFluidHandlerItem itemFluidHandler;
            block5: {
                Optional capability;
                if (this.isEmpty() || !(capability = FluidUtil.getFluidHandler((ItemStack)this.getStack()).resolve()).isPresent()) break block4;
                itemFluidHandler = (IFluidHandlerItem)capability.get();
                itemTanks = itemFluidHandler.getTanks();
                if (itemTanks != 1) break block5;
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (fluidInItem.isEmpty() || !this.getFluidTank().isFluidValid(fluidInItem)) break block4;
                this.drainItemAndMove(outputSlot, fluidInItem);
                break block4;
            }
            if (itemTanks > 1) {
                FluidStack knownFluid;
                Object2ObjectOpenHashMap knownFluids = new Object2ObjectOpenHashMap();
                for (int itemTank = 0; itemTank < itemTanks; ++itemTank) {
                    FluidStack fluidInItem = itemFluidHandler.getFluidInTank(itemTank);
                    if (fluidInItem.isEmpty()) continue;
                    FluidInfo info = new FluidInfo(fluidInItem);
                    FluidStack knownFluid2 = (FluidStack)knownFluids.get(info);
                    if (knownFluid2 == null) {
                        if (itemFluidHandler.drain(fluidInItem, IFluidHandler.FluidAction.SIMULATE).isEmpty() || !this.getFluidTank().isFluidValid(fluidInItem)) continue;
                        knownFluids.put(info, fluidInItem.copy());
                        continue;
                    }
                    knownFluid2.grow(fluidInItem.getAmount());
                }
                Iterator iterator = knownFluids.values().iterator();
                while (!(!iterator.hasNext() || this.drainItemAndMove(outputSlot, knownFluid = (FluidStack)iterator.next()) && this.isEmpty())) {
                }
            }
        }
    }

    default public void drainTank(IInventorySlot outputSlot) {
        FluidStack fluidInTank;
        if (!this.isEmpty() && FluidUtil.getFluidHandler((ItemStack)this.getStack()).isPresent() && !(fluidInTank = this.getFluidTank().getFluid()).isEmpty()) {
            FluidStack simulatedDrain = this.getFluidTank().extract(fluidInTank.getAmount(), Action.SIMULATE, AutomationType.INTERNAL);
            if (simulatedDrain.isEmpty()) {
                return;
            }
            ItemStack inputCopy = StackUtils.size(this.getStack(), 1);
            Optional cap = FluidUtil.getFluidHandler((ItemStack)inputCopy).resolve();
            if (cap.isPresent()) {
                Optional containerCap;
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                int toDrain = fluidHandlerItem.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
                if (this.getCount() == 1 && (containerCap = FluidUtil.getFluidHandler((ItemStack)fluidHandlerItem.getContainer()).resolve()).isPresent() && ((IFluidHandlerItem)containerCap.get()).fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.setStack(fluidHandlerItem.getContainer());
                    this.setDraining(true);
                    MekanismUtils.logMismatchedStackSize(this.getFluidTank().shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    return;
                }
                if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
                    MekanismUtils.logMismatchedStackSize(this.getFluidTank().shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    this.setDraining(false);
                }
            }
        }
    }

    default public boolean drainItemAndMove(IInventorySlot outputSlot, FluidStack fluidToTransfer) {
        Optional containerCap;
        int toTransfer;
        FluidStack simulatedRemainder = this.getFluidTank().insert(fluidToTransfer, Action.SIMULATE, AutomationType.INTERNAL);
        int remainder = simulatedRemainder.getAmount();
        if (remainder == (toTransfer = fluidToTransfer.getAmount())) {
            return false;
        }
        ItemStack input = StackUtils.size(this.getStack(), 1);
        Optional cap = FluidUtil.getFluidHandler((ItemStack)input).resolve();
        if (!cap.isPresent()) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
        FluidStack drained = fluidHandlerItem.drain(new FluidStack(fluidToTransfer, toTransfer - remainder), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return false;
        }
        if (this.getCount() == 1 && (containerCap = FluidUtil.getFluidHandler((ItemStack)fluidHandlerItem.getContainer()).resolve()).isPresent() && !((IFluidHandlerItem)containerCap.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            this.setStack(fluidHandlerItem.getContainer());
            this.getFluidTank().insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            this.setFilling(true);
            return true;
        }
        if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
            this.getFluidTank().insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    default public boolean moveItem(IInventorySlot outputSlot, ItemStack stackToMove) {
        if (outputSlot.isEmpty()) {
            outputSlot.setStack(stackToMove);
        } else {
            ItemStack outputStack = outputSlot.getStack();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)stackToMove) || outputStack.func_190916_E() >= outputSlot.getLimit(outputStack)) {
                return false;
            }
            MekanismUtils.logMismatchedStackSize(outputSlot.growStack(1, Action.EXECUTE), 1L);
        }
        MekanismUtils.logMismatchedStackSize(this.shrinkStack(1, Action.EXECUTE), 1L);
        return true;
    }

    default public boolean fillTank() {
        Optional capability;
        if (this.getCount() == 1 && (capability = FluidUtil.getFluidHandler((ItemStack)this.getStack()).resolve()).isPresent()) {
            IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)capability.get();
            int tanks = itemFluidHandler.getTanks();
            if (tanks == 1) {
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (!fluidInItem.isEmpty() && this.getFluidTank().isFluidValid(fluidInItem) && this.fillHandlerFromOther(this.getFluidTank(), (IFluidHandler)itemFluidHandler, fluidInItem)) {
                    this.setStack(itemFluidHandler.getContainer());
                    return true;
                }
            } else if (tanks > 1) {
                Object2ObjectOpenHashMap knownFluids = new Object2ObjectOpenHashMap();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInItem = itemFluidHandler.getFluidInTank(tank);
                    if (fluidInItem.isEmpty()) continue;
                    FluidInfo info = new FluidInfo(fluidInItem);
                    FluidStack knownFluid = (FluidStack)knownFluids.get(info);
                    if (knownFluid == null) {
                        if (itemFluidHandler.drain(fluidInItem, IFluidHandler.FluidAction.SIMULATE).isEmpty() || !this.getFluidTank().isFluidValid(fluidInItem)) continue;
                        knownFluids.put(info, fluidInItem.copy());
                        continue;
                    }
                    knownFluid.grow(fluidInItem.getAmount());
                }
                if (!knownFluids.isEmpty()) {
                    boolean changed = false;
                    for (FluidStack knownFluid : knownFluids.values()) {
                        if (!this.fillHandlerFromOther(this.getFluidTank(), (IFluidHandler)itemFluidHandler, knownFluid)) continue;
                        changed = true;
                    }
                    if (changed) {
                        this.setStack(itemFluidHandler.getContainer());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    default public boolean fillHandlerFromOther(IExtendedFluidTank handlerToFill, IFluidHandler handlerToDrain, FluidStack fluid) {
        int drained;
        FluidStack simulatedRemainder;
        int remainder;
        FluidStack simulatedDrain = handlerToDrain.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
        if (!simulatedDrain.isEmpty() && (remainder = (simulatedRemainder = this.getFluidTank().insert(simulatedDrain, Action.SIMULATE, AutomationType.INTERNAL)).getAmount()) < (drained = simulatedDrain.getAmount())) {
            handlerToFill.insert(handlerToDrain.drain(new FluidStack(fluid, drained - remainder), IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    public static class FluidInfo {
        private final FluidStack fluidStack;

        public FluidInfo(FluidStack fluidStack) {
            this.fluidStack = fluidStack;
        }

        public boolean equals(Object other) {
            return other == this || other instanceof FluidInfo && this.fluidStack.isFluidEqual(((FluidInfo)other).fluidStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.fluidStack.getFluid().hashCode();
            if (this.fluidStack.hasTag()) {
                code = 31 * code + this.fluidStack.getTag().hashCode();
            }
            return code;
        }
    }
}

