/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class InventoryContainerSlot
extends Slot
implements IInsertableSlot {
    private static final IInventory emptyInventory = new Inventory(0);
    private final Consumer<ItemStack> uncheckedSetter;
    private final ContainerSlotType slotType;
    private final BasicInventorySlot slot;
    @Nullable
    private final SlotOverlay slotOverlay;

    public InventoryContainerSlot(BasicInventorySlot slot, int x, int y, ContainerSlotType slotType, @Nullable SlotOverlay slotOverlay, Consumer<ItemStack> uncheckedSetter) {
        super(emptyInventory, 0, x, y);
        this.slot = slot;
        this.slotType = slotType;
        this.slotOverlay = slotOverlay;
        this.uncheckedSetter = uncheckedSetter;
    }

    public IInventorySlot getInventorySlot() {
        return this.slot;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, Action action) {
        ItemStack remainder = this.slot.insertItem(stack, action, AutomationType.MANUAL);
        if (action.execute() && stack.func_190916_E() != remainder.func_190916_E()) {
            this.func_75218_e();
        }
        return remainder;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.slot.isEmpty()) {
            return this.insertItem(stack, Action.SIMULATE).func_190916_E() < stack.func_190916_E();
        }
        if (this.slot.extractItem(1, Action.SIMULATE, AutomationType.MANUAL).func_190926_b()) {
            return false;
        }
        return this.slot.isItemValidForInsertion(stack, AutomationType.MANUAL);
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return this.slot.getStack();
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        this.uncheckedSetter.accept(stack);
        this.func_75218_e();
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.slot.onContentsChanged();
    }

    public void func_75220_a(@Nonnull ItemStack current, @Nonnull ItemStack newStack) {
        this.slot.onContentsChanged();
    }

    public int func_75219_a() {
        return this.slot.getLimit(ItemStack.field_190927_a);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return this.slot.getLimit(stack);
    }

    public boolean func_82869_a(@Nonnull PlayerEntity player) {
        return !this.slot.extractItem(1, Action.SIMULATE, AutomationType.MANUAL).func_190926_b();
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.slot.extractItem(amount, Action.EXECUTE, AutomationType.MANUAL);
    }

    public ContainerSlotType getSlotType() {
        return this.slotType;
    }

    @Nullable
    public SlotOverlay getSlotOverlay() {
        return this.slotOverlay;
    }
}

