/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import org.apache.commons.lang3.math.Fraction;

@RecipeTypeMapper
public class SawmillRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekSawmill";
    }

    public String getDescription() {
        return "Maps Mekanism sawmill recipes. (Disabled by default, due to causing various EMC values to be removed pertaining to charcoal/wood)";
    }

    public boolean isAvailable() {
        return false;
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.SAWING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof SawmillRecipe)) {
            return false;
        }
        SawmillRecipe recipe = (SawmillRecipe)iRecipe;
        ItemStackIngredient input = recipe.getInput();
        int primaryMultiplier = 1;
        int secondaryMultiplier = 1;
        if (recipe.getSecondaryChance() > 0.0 && recipe.getSecondaryChance() < 1.0) {
            Fraction multiplier;
            try {
                multiplier = Fraction.getFraction((double)recipe.getSecondaryChance()).invert();
            }
            catch (ArithmeticException e) {
                return false;
            }
            primaryMultiplier = multiplier.getNumerator();
            secondaryMultiplier = multiplier.getDenominator();
        }
        boolean handled = false;
        for (ItemStack representation : input.getRepresentations()) {
            SawmillRecipe.ChanceOutput output = recipe.getOutput(representation);
            ItemStack mainOutput = output.getMainOutput();
            ItemStack secondaryOutput = output.getMaxSecondaryOutput();
            NSSItem nssInput = NSSItem.createItem((ItemStack)representation);
            IngredientHelper ingredientHelper = new IngredientHelper(mapper);
            if (secondaryOutput.func_190926_b()) {
                if (mainOutput.func_190926_b()) continue;
                ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.func_190916_E());
                if (!ingredientHelper.addAsConversion(mainOutput)) continue;
                handled = true;
                continue;
            }
            if (mainOutput.func_190926_b()) {
                ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.func_190916_E() * primaryMultiplier);
                if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)NSSItem.createItem((ItemStack)secondaryOutput), secondaryOutput.func_190916_E() * secondaryMultiplier)) continue;
                handled = true;
                continue;
            }
            NSSItem nssMainOutput = NSSItem.createItem((ItemStack)mainOutput);
            NSSItem nssSecondaryOutput = NSSItem.createItem((ItemStack)secondaryOutput);
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.func_190916_E() * primaryMultiplier);
            ingredientHelper.put((NormalizedSimpleStack)nssSecondaryOutput, -secondaryOutput.func_190916_E() * secondaryMultiplier);
            if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssMainOutput, mainOutput.func_190916_E() * primaryMultiplier)) {
                handled = true;
            }
            ingredientHelper.resetHelper();
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.func_190916_E() * primaryMultiplier);
            ingredientHelper.put((NormalizedSimpleStack)nssMainOutput, -mainOutput.func_190916_E() * primaryMultiplier);
            if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssSecondaryOutput, secondaryOutput.func_190916_E() * secondaryMultiplier)) continue;
            handled = true;
        }
        return handled;
    }
}

