/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.integration.lookingat.LookingAtElement;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends LookingAtElement {
    @Nonnull
    protected final FluidStack stored;
    protected final int capacity;

    public FluidElement(@Nonnull FluidStack stored, int capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.stored.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return MathUtils.clampToInt((double)level * (double)this.stored.getAmount() / (double)this.capacity);
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.stored.isEmpty() ? null : MekanismRenderer.getFluidTexture(this.stored, MekanismRenderer.FluidType.STILL);
    }

    @Override
    public ITextComponent getText() {
        int amount = this.stored.getAmount();
        if (amount == Integer.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(this.stored, MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(this.stored, amount);
    }

    @Override
    protected boolean applyRenderColor() {
        MekanismRenderer.color(this.stored);
        return true;
    }
}

