/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class RobitAIBase
extends Goal {
    protected final EntityRobit theRobit;
    protected final World world;
    protected final float moveSpeed;
    protected final PathNavigator thePathfinder;
    protected int timeToRecalcPath;
    protected float oldWaterCost;

    protected RobitAIBase(EntityRobit entityRobit, float speed) {
        this.theRobit = entityRobit;
        this.world = entityRobit.field_70170_p;
        this.moveSpeed = speed;
        this.thePathfinder = entityRobit.func_70661_as();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.theRobit.func_184643_a(PathNodeType.WATER);
        this.theRobit.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.thePathfinder.func_75499_g();
        this.theRobit.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    protected void updateTask(Entity target) {
        this.theRobit.func_70671_ap().func_75651_a(target, 6.0f, (float)this.theRobit.func_70646_bf() / 10.0f);
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.theRobit.func_184218_aH()) {
                if (this.theRobit.func_70068_e(target) >= 144.0) {
                    BlockPos targetPos = target.func_233580_cy_();
                    for (int i = 0; i < 10; ++i) {
                        if (!this.tryPathTo(target, targetPos.func_177958_n() + this.randomize(-3, 3), targetPos.func_177956_o() + this.randomize(-1, 1), targetPos.func_177952_p() + this.randomize(-3, 3))) continue;
                        return;
                    }
                } else {
                    this.thePathfinder.func_75497_a(target, (double)this.moveSpeed);
                }
            }
        }
    }

    private int randomize(int min, int max) {
        return this.theRobit.func_70681_au().nextInt(max - min + 1) + min;
    }

    private boolean tryPathTo(Entity target, int x, int y, int z) {
        if (Math.abs((double)x - target.func_226277_ct_()) < 2.0 && Math.abs((double)z - target.func_226281_cx_()) < 2.0 || !this.canNavigate(new BlockPos(x, y, z))) {
            return false;
        }
        this.theRobit.func_70012_b((double)x + 0.5, y, (double)z + 0.5, this.theRobit.field_70177_z, this.theRobit.field_70125_A);
        this.thePathfinder.func_75499_g();
        return true;
    }

    private boolean canNavigate(BlockPos pos) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathnodetype == PathNodeType.WALKABLE) {
            BlockPos blockpos = pos.func_177973_b((Vector3i)this.theRobit.func_233580_cy_());
            return this.world.func_226665_a__((Entity)this.theRobit, this.theRobit.func_174813_aQ().func_186670_a(blockpos));
        }
        return false;
    }
}

