/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import org.apache.commons.lang3.tuple.Pair;

public final class TransporterPathfinder {
    private TransporterPathfinder() {
    }

    private static List<Destination> getPaths(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min) {
        InventoryNetwork network = (InventoryNetwork)start.getTransmitterNetwork();
        if (network == null) {
            return Collections.emptyList();
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        List<InventoryNetwork.AcceptorData> acceptors = network.calculateAcceptors(request, stack, (Long2ObjectMap<IChunk>)chunkMap);
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (InventoryNetwork.AcceptorData data : acceptors) {
            Destination path = TransporterPathfinder.getPath(data, start, stack, min, (Long2ObjectMap<IChunk>)chunkMap);
            if (path == null) continue;
            paths.add(path);
        }
        Collections.sort(paths);
        return paths;
    }

    private static boolean checkPath(World world, List<BlockPos> path, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
        for (int i = path.size() - 1; i > 0; --i) {
            TileEntity tile = WorldUtils.getTileEntity((IWorld)world, chunkMap, path.get(i));
            if (tile instanceof TileEntityLogisticalTransporterBase) {
                EnumColor color = ((TileEntityLogisticalTransporterBase)tile).getTransmitter().getColor();
                if (color == null || color == stack.color) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static Destination getPath(InventoryNetwork.AcceptorData data, LogisticalTransporterBase start, TransporterStack stack, int min, Long2ObjectMap<IChunk> chunkMap) {
        final TransitRequest.TransitResponse response = data.getResponse();
        if (response.getSendingAmount() >= min) {
            BlockPos dest = data.getLocation();
            PathfinderCache.CachedPath test = PathfinderCache.getCache(start, dest, data.getSides());
            if (test != null && TransporterPathfinder.checkPath(start.getTileWorld(), test.getPath(), stack, chunkMap)) {
                return new Destination(test.getPath(), false, response, test.getCost());
            }
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction dir, TileEntity tile) {
                    return TransporterUtils.canInsert(tile, stack.color, response.getStack(), dir, false);
                }
            }, start.getTileWorld(), dest, start.getTilePos(), stack, chunkMap);
            List<BlockPos> path = p.getPath();
            if (path.size() >= 2) {
                PathfinderCache.addCachedPath(start, new PathfinderCache.PathData(start.getTilePos(), dest, p.getSide()), path, p.finalScore);
                return new Destination(path, false, response, p.finalScore);
            }
        }
        return null;
    }

    @Nullable
    public static Destination getNewBasePath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(LogisticalTransporterBase start, TransporterStack stack, TransitRequest request, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, request, min);
        Object2ObjectOpenHashMap destPaths = new Object2ObjectOpenHashMap();
        for (Destination d : paths) {
            BlockPos dest = d.getPath().get(0);
            Destination destination = (Destination)destPaths.get(dest);
            if (destination != null && destination.getPath().size() >= d.getPath().size()) continue;
            destPaths.put(dest, d);
        }
        ArrayList destinations = new ArrayList(destPaths.values());
        Collections.sort(destinations);
        Destination closest = null;
        if (!destinations.isEmpty()) {
            if (outputter.rrIndex <= destinations.size() - 1) {
                closest = (Destination)destinations.get(outputter.rrIndex);
                if (outputter.rrIndex == destinations.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < destinations.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)destinations.get(destinations.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        return closest;
    }

    public static Pair<List<BlockPos>, TransporterStack.Path> getIdlePath(LogisticalTransporterBase start, TransporterStack stack) {
        IdlePath d;
        Destination dest;
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        if (stack.homeLocation != null) {
            Pathfinder p = new Pathfinder(new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, Direction side, TileEntity tile) {
                    return TransporterUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            }, start.getTileWorld(), stack.homeLocation, start.getTilePos(), stack, (Long2ObjectMap<IChunk>)chunkMap);
            List<BlockPos> path = p.getPath();
            if (path.size() >= 2) {
                return Pair.of(path, (Object)((Object)TransporterStack.Path.HOME));
            }
            stack.homeLocation = null;
        }
        if ((dest = (d = new IdlePath(start.getTileWorld(), start.getTilePos(), stack)).find((Long2ObjectMap<IChunk>)chunkMap)) == null) {
            return null;
        }
        return Pair.of(dest.getPath(), (Object)((Object)dest.getPathType()));
    }

    public static class Pathfinder {
        private final Set<BlockPos> openSet;
        private final Set<BlockPos> closedSet;
        private final Map<BlockPos, BlockPos> navMap;
        private final Object2DoubleOpenHashMap<BlockPos> gScore;
        private final Object2DoubleOpenHashMap<BlockPos> fScore;
        private final BlockPos start;
        private final BlockPos finalNode;
        private final TransporterStack transportStack;
        private final DestChecker destChecker;
        private final World world;
        private double finalScore;
        private Direction side;
        private List<BlockPos> results;

        public Pathfinder(DestChecker checker, World world, BlockPos finishObj, BlockPos startObj, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
            this.destChecker = checker;
            this.world = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new ObjectOpenHashSet();
            this.closedSet = new ObjectOpenHashSet();
            this.navMap = new Object2ObjectOpenHashMap();
            this.gScore = new Object2DoubleOpenHashMap();
            this.fScore = new Object2DoubleOpenHashMap();
            this.results = new ArrayList<BlockPos>();
            this.find(chunkMap, this.start);
        }

        public boolean find(Long2ObjectMap<IChunk> chunkMap, BlockPos start) {
            this.openSet.add(start);
            this.gScore.put((Object)start, 0.0);
            this.fScore.put((Object)start, WorldUtils.distanceBetween(start, this.finalNode));
            boolean hasValidDirection = false;
            TileEntity startTile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, start);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                BlockPos neighbor = start.func_177972_a(direction);
                TileEntity neighborTile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, neighbor);
                if (this.transportStack.canInsertToTransporter(neighborTile, direction, startTile)) {
                    hasValidDirection = true;
                    break;
                }
                if (!this.isValidDestination(start, startTile, direction, neighbor, neighborTile)) continue;
                return true;
            }
            if (!hasValidDirection) {
                return false;
            }
            double maxSearchDistance = 2.0 * WorldUtils.distanceBetween(start, this.finalNode);
            while (!this.openSet.isEmpty()) {
                BlockPos currentNode = null;
                double lowestFScore = 0.0;
                for (BlockPos node : this.openSet) {
                    if (currentNode != null && !(this.fScore.getDouble((Object)node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.getDouble((Object)node);
                }
                if (currentNode == null) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                if (WorldUtils.distanceBetween(start, currentNode) > maxSearchDistance) continue;
                TileEntity currentNodeTile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, currentNode);
                double currentScore = this.gScore.getDouble((Object)currentNode);
                for (Direction direction : EnumUtils.DIRECTIONS) {
                    BlockPos neighbor = currentNode.func_177972_a(direction);
                    TileEntity neighborEntity = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, neighbor);
                    if (this.transportStack.canInsertToTransporter(neighborEntity, direction, currentNodeTile)) {
                        double tentativeG = currentScore + ((TileEntityLogisticalTransporterBase)neighborEntity).getTransmitter().getCost();
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.getDouble((Object)neighbor) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.getDouble((Object)neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put((Object)neighbor, tentativeG);
                        this.fScore.put((Object)neighbor, tentativeG + WorldUtils.distanceBetween(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!this.isValidDestination(currentNode, currentNodeTile, direction, neighbor, neighborEntity)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidDestination(BlockPos start, TileEntity startTile, Direction direction, BlockPos neighbor, TileEntity neighborTile) {
            TileEntityLogisticalTransporterBase transporter;
            if (neighbor.equals((Object)this.finalNode) && this.destChecker.isValid(this.transportStack, direction, neighborTile) && startTile instanceof TileEntityLogisticalTransporterBase && ((transporter = (TileEntityLogisticalTransporterBase)startTile).getTransmitter().canEmitTo(direction) || this.finalNode.equals((Object)this.transportStack.homeLocation) && transporter.getTransmitter().canConnect(direction))) {
                this.side = direction;
                this.results = this.reconstructPath(this.navMap, start);
                return true;
            }
            return false;
        }

        private List<BlockPos> reconstructPath(Map<BlockPos, BlockPos> navMap, BlockPos currentNode) {
            ArrayList<BlockPos> path = new ArrayList<BlockPos>();
            path.add(currentNode);
            if (navMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(navMap, navMap.get(currentNode)));
            }
            this.finalScore = this.gScore.getDouble((Object)currentNode) + WorldUtils.distanceBetween(currentNode, this.finalNode);
            return path;
        }

        public List<BlockPos> getPath() {
            ArrayList<BlockPos> path = new ArrayList<BlockPos>();
            path.add(this.finalNode);
            path.addAll(this.results);
            return path;
        }

        public Direction getSide() {
            return this.side;
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, Direction side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        private final TransitRequest.TransitResponse response;
        private final List<BlockPos> path;
        private final double score;
        private TransporterStack.Path pathType;

        public Destination(List<BlockPos> list, boolean inv, TransitRequest.TransitResponse ret, double gScore) {
            this.path = new ArrayList<BlockPos>(list);
            if (inv) {
                Collections.reverse(this.path);
            }
            this.response = ret;
            this.score = gScore;
        }

        public Destination setPathType(TransporterStack.Path type) {
            this.pathType = type;
            return this;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path);
        }

        @Override
        public int compareTo(@Nonnull Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return this.path.size() - dest.path.size();
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public TransporterStack.Path getPathType() {
            return this.pathType;
        }

        public List<BlockPos> getPath() {
            return this.path;
        }
    }

    public static class IdlePath {
        private final World world;
        private final BlockPos start;
        private final TransporterStack transportStack;

        public IdlePath(World world, BlockPos obj, TransporterStack stack) {
            this.world = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public Destination find(Long2ObjectMap<IChunk> chunkMap) {
            Destination newPath;
            ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
            ret.add(this.start);
            TileEntity startTile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, this.start);
            if (this.transportStack.idleDir == null) {
                return this.getDestination(chunkMap, ret, startTile);
            }
            TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IWorld)this.world, chunkMap, this.start.func_177972_a(this.transportStack.idleDir));
            if (this.transportStack.canInsertToTransporter(tile, this.transportStack.idleDir, startTile)) {
                this.loopSide(chunkMap, ret, this.transportStack.idleDir, startTile);
                return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
            }
            TransitRequest.SimpleTransitRequest request = TransitRequest.simple(this.transportStack.itemStack);
            if (startTile instanceof TileEntityLogisticalTransporterBase && (newPath = TransporterPathfinder.getNewBasePath(((TileEntityLogisticalTransporterBase)startTile).getTransmitter(), this.transportStack, request, 0)) != null && newPath.getResponse() != null) {
                this.transportStack.idleDir = null;
                newPath.setPathType(TransporterStack.Path.DEST);
                return newPath;
            }
            return this.getDestination(chunkMap, ret, startTile);
        }

        @Nullable
        private Destination getDestination(Long2ObjectMap<IChunk> chunkMap, ArrayList<BlockPos> ret, TileEntity startTile) {
            Direction newSide = this.findSide(chunkMap);
            if (newSide == null) {
                return null;
            }
            this.transportStack.idleDir = newSide;
            this.loopSide(chunkMap, ret, newSide, startTile);
            return new Destination(ret, true, null, 0.0).setPathType(TransporterStack.Path.NONE);
        }

        private void loopSide(Long2ObjectMap<IChunk> chunkMap, List<BlockPos> list, Direction side, TileEntity startTile) {
            TileEntity lastTile = startTile;
            BlockPos pos = this.start.func_177972_a(side);
            TileEntity tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, pos);
            while (this.transportStack.canInsertToTransporter(tile, side, lastTile)) {
                lastTile = tile;
                list.add(pos);
                pos = pos.func_177972_a(side);
                tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, pos);
            }
        }

        private Direction findSide(Long2ObjectMap<IChunk> chunkMap) {
            TileEntity startTile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, this.start);
            if (this.transportStack.idleDir == null) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IWorld)this.world, chunkMap, this.start.func_177972_a(side));
                    if (!this.transportStack.canInsertToTransporter(tile, side, startTile)) continue;
                    return side;
                }
            } else {
                Direction opposite = this.transportStack.idleDir.func_176734_d();
                for (Direction side : EnumSet.complementOf(EnumSet.of(opposite))) {
                    TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IWorld)this.world, chunkMap, this.start.func_177972_a(side));
                    if (!this.transportStack.canInsertToTransporter(tile, side, startTile)) continue;
                    return side;
                }
                TileEntityLogisticalTransporterBase tile = WorldUtils.getTileEntity(TileEntityLogisticalTransporterBase.class, (IWorld)this.world, chunkMap, this.start.func_177972_a(opposite));
                if (this.transportStack.canInsertToTransporter(tile, opposite, startTile)) {
                    return opposite;
                }
            }
            return null;
        }
    }
}

