/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ForceRetrogenCommand {
    private static final SimpleCommandExceptionType RETROGEN_NOT_ENABLED = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_RETROGEN_DISABLED.translate(new Object[0]));
    private static final SimpleCommandExceptionType NO_CHUNKS_QUEUED = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_RETROGEN_FAILURE.translate(new Object[0]));

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"retrogen").requires(cs -> cs.func_197034_c(2))).executes(ctx -> {
            ColumnPos pos = new ColumnPos(new BlockPos(((CommandSource)ctx.getSource()).func_197036_d()));
            return ForceRetrogenCommand.addChunksToRegen((CommandSource)ctx.getSource(), pos, pos);
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"from", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> {
            ColumnPos from = ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"from");
            return ForceRetrogenCommand.addChunksToRegen((CommandSource)ctx.getSource(), from, from);
        })).then(Commands.func_197056_a((String)"to", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> ForceRetrogenCommand.addChunksToRegen((CommandSource)ctx.getSource(), ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"from"), ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"to")))));
    }

    private static int addChunksToRegen(CommandSource source, ColumnPos start, ColumnPos end) throws CommandSyntaxException {
        if (!MekanismConfig.world.enableRegeneration.get()) {
            throw RETROGEN_NOT_ENABLED.create();
        }
        int xStart = Math.min(start.field_219439_a, end.field_219439_a);
        int xEnd = Math.max(start.field_219439_a, end.field_219439_a);
        int zStart = Math.min(start.field_219440_b, end.field_219440_b);
        int zEnd = Math.max(start.field_219440_b, end.field_219440_b);
        if (xStart < -30000000 || zStart < -30000000 || xEnd >= 30000000 || zEnd >= 30000000) {
            throw BlockPosArgument.field_197279_c.create();
        }
        int chunkXStart = xStart >> 4;
        int chunkXEnd = xEnd >> 4;
        int chunkZStart = zStart >> 4;
        int chunkZEnd = zEnd >> 4;
        ServerWorld world = source.func_197023_e();
        RegistryKey registryKey = world.func_234923_W_();
        boolean hasChunks = false;
        for (int chunkX = chunkXStart; chunkX <= chunkXEnd; ++chunkX) {
            for (int chunkZ = chunkZStart; chunkZ <= chunkZEnd; ++chunkZ) {
                if (!world.func_217354_b(chunkX, chunkZ)) continue;
                Mekanism.worldTickHandler.addRegenChunk((RegistryKey<World>)registryKey, new ChunkPos(chunkX, chunkZ));
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RETROGEN_CHUNK_QUEUED.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismLang.GENERIC_WITH_COMMA.translate(chunkX, chunkZ), EnumColor.INDIGO, registryKey.func_240901_a_()), true);
                hasChunks = true;
            }
        }
        if (!hasChunks) {
            throw NO_CHUNKS_QUEUED.create();
        }
        return 0;
    }
}

