/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTickHandler {
    public static boolean isOnGroundOrSleeping(PlayerEntity player) {
        int z;
        int y;
        if (player.func_70608_bn()) {
            return true;
        }
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(player.func_226278_cu_() - 0.01)), z = MathHelper.func_76128_c((double)player.func_226281_cx_()));
        BlockState s = player.field_70170_p.func_180495_p(pos);
        VoxelShape shape = s.func_196954_c((IBlockReader)player.field_70170_p, pos);
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB playerBox = player.func_174813_aQ();
        return !s.isAir((IBlockReader)player.field_70170_p, pos) && playerBox.func_72317_d(0.0, -0.01, 0.0).func_72326_a(shape.func_197752_a().func_186670_a(pos));
    }

    public static boolean isScubaMaskOn(PlayerEntity player, ItemStack tank) {
        ItemStack mask = player.func_184582_a(EquipmentSlotType.HEAD);
        return !tank.func_190926_b() && !mask.func_190926_b() && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemScubaMask && ChemicalUtil.hasGas(tank) && ((ItemScubaTank)tank.func_77973_b()).getFlowing(tank);
    }

    private static boolean isFlamethrowerOn(PlayerEntity player, ItemStack currentItem) {
        return Mekanism.playerState.isFlamethrowerOn(player) && !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower;
    }

    public static float getStepBoost(PlayerEntity player) {
        ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
        if (!stack.func_190926_b() && !player.func_225608_bj_()) {
            ItemFreeRunners freeRunners;
            if (stack.func_77973_b() instanceof ItemFreeRunners && (freeRunners = (ItemFreeRunners)stack.func_77973_b()).getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
                return 0.5f;
            }
            ModuleMekaSuit.ModuleHydraulicPropulsionUnit module = Modules.load(stack, Modules.HYDRAULIC_PROPULSION_UNIT);
            if (module != null && module.isEnabled()) {
                return module.getStepHeight();
            }
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd(event.player);
        }
    }

    private void tickEnd(PlayerEntity player) {
        ItemStack chest;
        ItemStack currentItem;
        Mekanism.playerState.updateStepAssist(player);
        if (player instanceof ServerPlayerEntity) {
            Mekanism.radiationManager.tickServer((ServerPlayerEntity)player);
        }
        if (CommonPlayerTickHandler.isFlamethrowerOn(player, currentItem = player.field_71071_by.func_70448_g())) {
            player.field_70170_p.func_217376_c((Entity)new EntityFlame(player));
            if (MekanismUtils.isPlayingMode(player)) {
                ((ItemFlamethrower)currentItem.func_77973_b()).useGas(currentItem, 1L);
            }
        }
        if (CommonPlayerTickHandler.isJetpackOn(player, chest = player.func_184582_a(EquipmentSlotType.CHEST))) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            Vector3d motion = player.func_213322_ci();
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.5), motion.func_82616_c());
            } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player.func_110124_au(), 0);
                boolean descending = Mekanism.keyMap.has(player.func_110124_au(), 1);
                if (!ascending && !descending || ascending && descending) {
                    if (motion.func_82617_b() > 0.0) {
                        player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, 0.0), motion.func_82616_c());
                    } else if (motion.func_82617_b() < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                        player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.0), motion.func_82616_c());
                    }
                } else if (ascending) {
                    player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.2), motion.func_82616_c());
                } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                    player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, -0.2), motion.func_82616_c());
                }
            }
            player.field_70143_R = 0.0f;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
            }
            if (chest.func_77973_b() instanceof ItemJetpack) {
                ((ItemJetpack)chest.func_77973_b()).useGas(chest, 1L);
            } else {
                ((ItemMekaSuitArmor)chest.func_77973_b()).useGas(chest, (Gas)MekanismGases.HYDROGEN.get(), 1L);
            }
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest)) {
            ItemScubaTank tank = (ItemScubaTank)chest.func_77973_b();
            int max = 300;
            tank.useGas(chest, 1L);
            GasStack received = tank.useGas(chest, 300 - player.func_70086_ai());
            if (!received.isEmpty()) {
                player.func_70050_g(player.func_70086_ai() + (int)received.getAmount());
            }
            if (player.func_70086_ai() == 300) {
                for (EffectInstance effect : player.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        effect.func_76455_a((LivingEntity)player, () -> MekanismUtils.onChangedPotionEffect((LivingEntity)player, effect, true));
                    }
                }
            }
        }
        Mekanism.playerState.updateFlightInfo(player);
    }

    private static boolean isJetpackOn(PlayerEntity player, ItemStack chest) {
        if (MekanismUtils.isPlayingMode(player) && !chest.func_190926_b()) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return Mekanism.keyMap.has(player.func_110124_au(), 0);
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player.func_110124_au(), 0);
                boolean descending = Mekanism.keyMap.has(player.func_110124_au(), 1);
                if (!ascending || descending) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGravitationalModulationReady(PlayerEntity player) {
        ModuleMekaSuit.ModuleGravitationalModulatingUnit module = Modules.load(player.func_184582_a(EquipmentSlotType.CHEST), Modules.GRAVITATIONAL_MODULATING_UNIT);
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get();
        return MekanismUtils.isPlayingMode(player) && module != null && module.isEnabled() && module.getContainerEnergy().greaterOrEqual(usage);
    }

    public static boolean isGravitationalModulationOn(PlayerEntity player) {
        return CommonPlayerTickHandler.isGravitationalModulationReady(player) && player.field_71075_bZ.field_75100_b;
    }

    public static ItemJetpack.JetpackMode getJetpackMode(ItemStack stack) {
        ModuleJetpackUnit module;
        if (stack.func_77973_b() instanceof ItemJetpack && ChemicalUtil.hasGas(stack)) {
            return ((ItemJetpack)stack.func_77973_b()).getMode(stack);
        }
        if (stack.func_77973_b() instanceof IModuleContainerItem && ChemicalUtil.hasChemical(stack, (Chemical)MekanismGases.HYDROGEN.get()) && (module = Modules.load(stack, Modules.JETPACK_UNIT)) != null && module.isEnabled()) {
            return module.getMode();
        }
        return null;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        FloatingLong energyRequirement;
        FloatingLong simulatedExtract;
        IEnergyContainer energyContainer;
        ItemStack headStack;
        LivingEntity base = event.getEntityLiving();
        if (event.getSource().func_82725_o() && !(headStack = base.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b()) {
            if (headStack.func_77973_b() instanceof ItemScubaMask) {
                ItemStack chestStack = base.func_184582_a(EquipmentSlotType.CHEST);
                if (!chestStack.func_190926_b() && chestStack.func_77973_b() instanceof ItemScubaTank && ((ItemScubaTank)chestStack.func_77973_b()).getFlowing(chestStack) && ChemicalUtil.hasGas(chestStack)) {
                    event.setCanceled(true);
                    return;
                }
            } else {
                FloatingLong energyRequirement2;
                ModuleMekaSuit.ModuleInhalationPurificationUnit module = Modules.load(headStack, Modules.INHALATION_PURIFICATION_UNIT);
                if (module != null && module.isEnabled() && module.canUseEnergy(base, energyRequirement2 = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce.get()).multiply(event.getAmount()))) {
                    module.useEnergy(base, energyRequirement2);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (event.getSource() == DamageSource.field_76379_h && (energyContainer = this.getFallAbsorptionEnergyContainer(base)) != null && (simulatedExtract = energyContainer.extract(energyRequirement = ((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).multiply(event.getAmount()), Action.SIMULATE, AutomationType.MANUAL)).equals(energyRequirement)) {
            energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Object energyRequirement;
        FloatingLong extracted;
        ModuleMekaSuit.ModuleInhalationPurificationUnit module;
        ItemStack headStack;
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76379_h) {
            FloatingLong energyRequirement2;
            FloatingLong extracted2;
            IEnergyContainer energyContainer = this.getFallAbsorptionEnergyContainer(entity);
            if (energyContainer != null && !(extracted2 = energyContainer.extract(energyRequirement2 = ((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).multiply(event.getAmount()), Action.EXECUTE, AutomationType.MANUAL)).isZero()) {
                FloatingLong remainder = energyRequirement2.subtract(extracted2);
                if (remainder.isZero()) {
                    event.setCanceled(true);
                    return;
                }
                float newDamage = remainder.divide((FloatingLong)MekanismConfig.gear.freeRunnerFallEnergyCost.get()).floatValue();
                if (newDamage == 0.0f) {
                    event.setCanceled(true);
                    return;
                }
                event.setAmount(newDamage);
            }
        } else if (event.getSource().func_82725_o() && !(headStack = entity.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() && (module = Modules.load(headStack, Modules.INHALATION_PURIFICATION_UNIT)) != null && module.isEnabled() && !(extracted = module.useEnergy(entity, (FloatingLong)(energyRequirement = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce.get()).multiply(event.getAmount())))).isZero()) {
            FloatingLong remainder = ((FloatingLong)energyRequirement).subtract(extracted);
            if (remainder.isZero()) {
                event.setCanceled(true);
                return;
            }
            float newDamage = remainder.divide((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageMagicReduce.get()).floatValue();
            if (newDamage == 0.0f) {
                event.setCanceled(true);
                return;
            }
            event.setAmount(newDamage);
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            float ratioAbsorbed = 0.0f;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!(stack.func_77973_b() instanceof ItemMekaSuitArmor)) continue;
                ratioAbsorbed += ((ItemMekaSuitArmor)stack.func_77973_b()).getDamageAbsorbed(stack, event.getSource(), event.getAmount());
            }
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                } else {
                    event.setAmount(damageRemaining);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        ModuleMekaSuit.ModuleHydraulicPropulsionUnit module;
        if (event.getEntityLiving() instanceof PlayerEntity && (module = Modules.load((player = (PlayerEntity)event.getEntityLiving()).func_184582_a(EquipmentSlotType.FEET), Modules.HYDRAULIC_PROPULSION_UNIT)) != null && module.isEnabled() && Mekanism.keyMap.has(player.func_110124_au(), 2)) {
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get()).multiply(module.getBoost() / 0.1f);
            if (module.getContainerEnergy().greaterOrEqual(usage)) {
                float boost = module.getBoost();
                ModuleLocomotiveBoostingUnit boostModule = Modules.load(player.func_184582_a(EquipmentSlotType.LEGS), Modules.LOCOMOTIVE_BOOSTING_UNIT);
                if (boostModule != null && boostModule.isEnabled() && boostModule.canFunction(player)) {
                    boost = (float)Math.sqrt(boost);
                }
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)boost, 0.0));
                module.useEnergy((LivingEntity)player, usage);
            }
        }
    }

    @Nullable
    private IEnergyContainer getFallAbsorptionEnergyContainer(LivingEntity base) {
        ItemFreeRunners boots;
        ItemStack feetStack = base.func_184582_a(EquipmentSlotType.FEET);
        if (!feetStack.func_190926_b() && (feetStack.func_77973_b() instanceof ItemFreeRunners ? (boots = (ItemFreeRunners)feetStack.func_77973_b()).getMode(feetStack) == ItemFreeRunners.FreeRunnerMode.NORMAL : feetStack.func_77973_b() instanceof ItemMekaSuitArmor)) {
            return StorageUtils.getEnergyContainer(feetStack, 0);
        }
        return null;
    }
}

