/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.button.GuiCloseButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.lib.Color;
import net.minecraft.inventory.container.Container;

public class GuiWindow
extends GuiTexturedElement {
    private static final Color OVERLAY_COLOR = Color.rgbai(60, 60, 60, 128);
    private Runnable closeListener;
    private Runnable reattachListener;
    private boolean dragging = false;
    private double dragX;
    private double dragY;
    private int prevDX;
    private int prevDY;
    protected InteractionStrategy interactionStrategy = InteractionStrategy.CONTAINER;

    public GuiWindow(IGuiWrapper gui, int x, int y, int width, int height) {
        super(GuiMekanism.BASE_BACKGROUND, gui, x, y, width, height);
        this.isOverlay = true;
        this.field_230693_o_ = true;
        if (!this.isFocusOverlay()) {
            this.addCloseButton();
        }
    }

    protected void addCloseButton() {
        this.addChild(new GuiCloseButton(this.getGuiObj(), this.field_230690_l_ + 6, this.field_230691_m_ + 6, this));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Container c;
        boolean ret = super.func_231044_a_(mouseX, mouseY, button);
        if (this.func_231047_b_(mouseX, mouseY)) {
            if (mouseY < (double)(this.field_230691_m_ + 18)) {
                this.dragging = true;
                this.dragX = mouseX;
                this.dragY = mouseY;
                this.prevDX = 0;
                this.prevDY = 0;
            }
        } else if (!ret && this.interactionStrategy.allowContainer() && this.guiObj instanceof GuiMekanism && !((c = ((GuiMekanism)this.guiObj).func_212873_a_()) instanceof IEmptyContainer) && mouseX >= (double)this.guiObj.getLeft() && mouseX < (double)(this.guiObj.getLeft() + this.guiObj.getWidth()) && mouseY >= (double)(this.guiObj.getTop() + this.guiObj.getHeight() - 90)) {
            return false;
        }
        return ret || !this.interactionStrategy.allowAll();
    }

    @Override
    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.dragging) {
            int newDX = (int)Math.round(mouseX - this.dragX);
            int newDY = (int)Math.round(mouseY - this.dragY);
            int changeX = Math.max(-this.field_230690_l_, Math.min(minecraft.func_228018_at_().func_198107_o() - (this.field_230690_l_ + this.field_230688_j_), newDX - this.prevDX));
            int changeY = Math.max(-this.field_230691_m_, Math.min(minecraft.func_228018_at_().func_198087_p() - (this.field_230691_m_ + this.field_230689_k_), newDY - this.prevDY));
            this.prevDX = newDX;
            this.prevDY = newDY;
            this.move(changeX, changeY);
        }
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        this.dragging = false;
    }

    @Override
    public void renderBackgroundOverlay(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.isFocusOverlay()) {
            MekanismRenderer.renderColorOverlay(matrix, 0, 0, minecraft.func_228018_at_().func_198107_o(), minecraft.func_228018_at_().func_198087_p(), OVERLAY_COLOR.rgba());
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.SHADOW, 4, 4, this.getButtonX() - 3, this.getButtonY() - 3, this.getButtonWidth() + 6, this.getButtonHeight() + 6, 256, 256);
            MekanismRenderer.resetColor();
        }
        GuiWindow.minecraft.field_71446_o.func_110577_a(this.getResource());
        this.renderBackgroundTexture(matrix, this.getResource(), 4, 4);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void setListenerTab(Supplier<? extends GuiElement> elementSupplier) {
        this.closeListener = () -> {
            ((GuiElement)elementSupplier.get()).field_230693_o_ = true;
        };
        this.reattachListener = () -> {
            ((GuiElement)elementSupplier.get()).field_230693_o_ = false;
        };
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        if (this.reattachListener != null) {
            this.reattachListener.run();
        }
    }

    public void renderBlur(MatrixStack matrix) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.BLUR, 4, 4, this.relativeX, this.relativeY, this.field_230688_j_, this.field_230689_k_, 256, 256);
        MekanismRenderer.resetColor();
    }

    public void close() {
        this.children.forEach(GuiElement::onWindowClose);
        this.guiObj.removeWindow(this);
        if (this.guiObj instanceof GuiMekanism) {
            ((GuiMekanism)this.guiObj).func_231035_a_(null);
        }
        if (this.closeListener != null) {
            this.closeListener.run();
        }
    }

    protected boolean isFocusOverlay() {
        return false;
    }

    public static enum InteractionStrategy {
        NONE,
        CONTAINER,
        ALL;


        boolean allowContainer() {
            return this != NONE;
        }

        boolean allowAll() {
            return this == ALL;
        }
    }
}

