/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public abstract class GuiFilterBase<FILTER extends IFilter, TILE extends TileEntityContainerBlock>
extends GuiFilter<TILE> {
    protected String status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
    protected FILTER origFilter;
    protected FILTER filter;
    protected boolean isNew;
    protected int ticker;
    protected GuiButton saveButton;
    protected GuiButton deleteButton;
    protected GuiButton backButton;
    protected GuiButton replaceButton;
    protected GuiButton defaultButton;
    protected GuiButton colorButton;

    protected GuiFilterBase(TILE tile, Container container) {
        super(tile, container);
    }

    protected GuiFilterBase(EntityPlayer player, TILE tile) {
        super(player, tile);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.isNew) {
            this.deleteButton.field_146124_l = false;
        }
    }

    protected void transporterMouseClicked(int button, TransporterFilter filter) {
        if (button == 1 && this.colorButton.func_146115_a()) {
            SoundHandler.playSound(SoundEvents.field_187909_gi);
            filter.color = TransporterUtils.decrement(filter.color);
        }
    }

    protected void drawMinerForegroundLayer(int mouseX, int mouseY, ItemStack stack) {
        if (this.filter instanceof MinerFilter) {
            MinerFilter mFilter = (MinerFilter)this.filter;
            this.renderItem(stack, 12, 19);
            this.renderItem(mFilter.replaceStack, 149, 19);
            if (this.replaceButton.func_146115_a()) {
                this.displayTooltip(LangUtils.localize("gui.digitalMiner.requireReplace") + ": " + LangUtils.transYesNo(mFilter.requireStack), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        }
    }

    protected void drawTransporterForegroundLayer(int mouseX, int mouseY, @Nonnull ItemStack stack) {
        if (this.filter instanceof TransporterFilter) {
            TransporterFilter tFilter = (TransporterFilter)this.filter;
            this.field_146289_q.func_78276_b(LangUtils.transOnOff(tFilter.allowDefault), 24, 66, 0x404040);
            this.renderItem(stack, 12, 19);
            this.drawTransporterForegroundText(mouseX - this.field_147003_i, mouseY - this.field_147009_r, tFilter);
        }
    }

    protected void drawTransporterForegroundText(int xAxis, int yAxis, TransporterFilter filter) {
        if (this.defaultButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
        } else if (this.colorButton.func_146115_a()) {
            if (filter.color != null) {
                this.displayTooltip(filter.color.getColoredName(), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
    }

    protected void actionPerformedMinerCommon(GuiButton guibutton, MinerFilter filter) {
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            this.sendPacketToServer(this.isNew ? 5 : 0);
        } else if (guibutton.field_146127_k == this.replaceButton.field_146127_k) {
            filter.requireStack = !filter.requireStack;
        }
    }

    protected void actionPerformedTransporter(GuiButton guibutton, TransporterFilter filter) {
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            this.sendPacketToServer(this.isNew ? 4 : 0);
        } else if (guibutton.field_146127_k == this.defaultButton.field_146127_k) {
            filter.allowDefault = !filter.allowDefault;
        } else if (guibutton.field_146127_k == this.colorButton.field_146127_k) {
            filter.color = Keyboard.isKeyDown((int)42) ? null : TransporterUtils.increment(filter.color);
        }
    }

    protected boolean overReplaceOutput(int xAxis, int yAxis) {
        return xAxis >= 149 && xAxis <= 165 && yAxis >= 19 && yAxis <= 35;
    }

    protected void minerFilterClickCommon(int xAxis, int yAxis, MinerFilter filter) {
        if (this.overReplaceOutput(xAxis, yAxis)) {
            boolean doNull = false;
            ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            ItemStack toUse = ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                    toUse = stack.func_77946_l();
                    toUse.func_190920_e(1);
                }
            } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                doNull = true;
            }
            if (!toUse.func_190926_b() || doNull) {
                filter.replaceStack = toUse;
            }
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

