/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.blocks.BlockDecorative;
import matteroverdrive.data.quest.logic.QuestLogicBlockInteract;
import matteroverdrive.tile.TileEntityTritaniumCrate;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MOWorldGenCargoShip
extends MOWorldGenBuilding<Worker> {
    private static final int MIN_DISTANCE_APART = 4096;

    public MOWorldGenCargoShip(String name) {
        super(name, new ResourceLocation("matteroverdrive:textures/world/cargo_ship.png"), 58, 23);
        for (BlockDecorative blockDecorative : BlockDecorative.decorativeBlocks) {
            this.addMapping(blockDecorative.getBlockColor(0), blockDecorative);
        }
        this.addMapping(14392378, MatterOverdrive.BLOCKS.holoSign);
        this.addMapping(6291390, MatterOverdrive.BLOCKS.transporter);
        this.addMapping(13826896, MatterOverdrive.BLOCKS.industrialGlass);
        this.addMapping(14418392, Blocks.field_150452_aw);
        this.addMapping(16542516, new MOImageGen.BlockMapping(true, Blocks.field_150352_o, Blocks.field_150366_p, Blocks.field_150365_q, MatterOverdrive.BLOCKS.tritaniumOre));
        this.addMapping(857638, MatterOverdrive.BLOCKS.fusionReactorIO);
        this.addMapping(1781751, MatterOverdrive.BLOCKS.network_pipe);
        this.addMapping(2040594, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.LIME.func_176765_a()]);
        this.addMapping(11225124, Blocks.field_180407_aO);
        this.addMapping(6870840, Blocks.field_150404_cg);
        this.addMapping(12446351, Blocks.field_150468_ap);
        this.addMapping(15726397, MatterOverdrive.BLOCKS.network_switch);
        this.addMapping(11070748, MatterOverdrive.BLOCKS.heavy_matter_pipe);
        this.addMapping(4925533, Blocks.field_150476_ad);
        this.addMapping(13621074, MatterOverdrive.BLOCKS.network_router);
        this.addMapping(5082579, MatterOverdrive.BLOCKS.pattern_monitor);
        this.addMapping(7025972, Blocks.field_150324_C);
        this.addMapping(0xFF00FF, Blocks.field_150350_a);
        this.addMapping(6919692, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.RED.func_176765_a()]);
    }

    @Override
    protected void onGeneration(Random random, World world, BlockPos pos, Worker worker) {
        TileEntity tileEntity;
        if (worker.contractDestination != null && (tileEntity = world.func_175625_s(worker.contractDestination)) instanceof TileEntityTritaniumCrate) {
            ItemStack contract = worker.contractQuest.getContract();
            ((TileEntityTritaniumCrate)tileEntity).getInventory().addItem(contract);
        }
    }

    @Override
    public int getMetaFromColor(int color, Random random) {
        return 255 - this.getAlphaFromColor(color);
    }

    @Override
    public boolean isLocationValid(World world, BlockPos pos) {
        return world.func_180495_p(pos = new BlockPos(pos.func_177958_n(), Math.min(pos.func_177956_o() + 86, world.func_72800_K() - 18), pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(this.layerWidth, 0, 0)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(0, 0, this.layerHeight)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(this.layerWidth, 0, this.layerHeight)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(0, 16, 0)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(this.layerWidth, 16, 0)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(0, 16, this.layerHeight)) == Blocks.field_150350_a && world.func_180495_p(pos.func_177982_a(this.layerWidth, 16, this.layerHeight)) == Blocks.field_150350_a;
    }

    @Override
    public boolean shouldGenerate(Random random, World world, BlockPos pos) {
        return (world.field_73011_w.getDimension() == 0 || world.field_73011_w.getDimension() == 1) && this.isFarEnoughFromOthers(world, pos.func_177958_n(), pos.func_177952_p(), 4096) && random.nextDouble() < 0.1;
    }

    @Override
    public void onGenerationWorkerCreated(Worker worker) {
        super.onGenerationWorkerCreated(worker);
        this.setyOffset(86);
    }

    @Override
    public Worker getNewWorkerInstance() {
        return new Worker();
    }

    @Override
    public void onBlockPlace(World world, IBlockState blockState, BlockPos pos, Random random, int color, Worker worker) {
        TileEntity tritaniumCrate;
        if (this.colorsMatch(color, 6919692)) {
            TileEntity tritaniumCrate2 = world.func_175625_s(pos);
            if (tritaniumCrate2 instanceof TileEntityTritaniumCrate) {
                worker.setQuestPos(pos);
                ItemStack itemStack = new ItemStack((Item)MatterOverdrive.ITEMS.isolinear_circuit).func_151001_c("Trade Route Agreement");
                ((TileEntityTritaniumCrate)tritaniumCrate2).getInventory().addItem(itemStack);
            }
        } else if (this.colorsMatch(color, 2040594) && (tritaniumCrate = world.func_175625_s(pos)) instanceof TileEntityTritaniumCrate && !worker.questAdded) {
            worker.markQuestAdded();
            worker.contractDestination = pos;
        }
    }

    static class Worker
    extends MOWorldGenBuilding.WorldGenBuildingWorker {
        private QuestStack contractQuest = new QuestStack(MatterOverdrive.QUESTS.getQuestByName("trade_route"));
        private BlockPos contractDestination;
        private boolean questAdded;

        private void setQuestPos(BlockPos pos) {
            QuestLogicBlockInteract.setBlockPosition(this.contractQuest, pos);
        }

        private void markQuestAdded() {
            this.questAdded = true;
        }
    }
}

