/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MOSandPit
extends MOWorldGenBuilding {
    private int airLeeway;

    public MOSandPit(String name, int airLeeway) {
        super(name, new ResourceLocation("matteroverdrive:textures/world/sand_pit.png"), 24, 24);
        this.setMaxDistanceToAir(airLeeway);
        this.setyOffset(-9);
        this.validSpawnBlocks = new Block[]{Blocks.field_150354_m};
        this.airLeeway = airLeeway;
        this.name = name;
        this.addMapping(14801717, Blocks.field_150322_A);
        this.addMapping(0xF1F1F1, Blocks.field_150350_a);
        this.addMapping(0xFFFF00, new Block[]{Blocks.field_150354_m});
        this.addMapping(13055457, Blocks.field_150426_aN);
        this.addMapping(3515105, new Block[]{Blocks.field_150355_j});
        this.addMapping(3513057, MatterOverdrive.BLOCKS.decorative_tritanium_plate);
        this.addMapping(16745472, MatterOverdrive.BLOCKS.decorative_coils);
        this.addMapping(7029760, Blocks.field_180407_aO);
    }

    public boolean isFlat(World world, BlockPos pos) {
        BlockPos y10 = world.func_175645_m(pos.func_177982_a(this.layerWidth, 0, 0));
        BlockPos y11 = world.func_175645_m(pos.func_177982_a(this.layerWidth, 0, this.layerHeight));
        BlockPos y01 = world.func_175645_m(pos.func_177982_a(0, 0, this.layerHeight));
        if (Math.abs(pos.func_177956_o() - y10.func_177956_o()) <= this.airLeeway && Math.abs(pos.func_177956_o() - y11.func_177956_o()) <= this.airLeeway && Math.abs(pos.func_177956_o() - y01.func_177956_o()) <= this.airLeeway) {
            return this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, pos) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, pos.func_177982_a(this.layerWidth, 0, 0)) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, pos.func_177982_a(0, 0, this.layerHeight)) && this.blockBelowMatches(this.airLeeway, world, (Block)Blocks.field_150354_m, pos.func_177982_a(this.layerWidth, 0, this.layerHeight));
        }
        return false;
    }

    private boolean blockBelowMatches(int airLeeway, World world, Block block, BlockPos pos) {
        for (int i = 0; i < airLeeway; ++i) {
            if (world.func_180495_p(pos.func_177982_a(0, -i, 0)).func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    private boolean isPointOnSurface(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() == Blocks.field_150350_a;
    }

    @Override
    public void placeBlock(World world, int color, BlockPos pos, int layer, Random random, int placeNotify, MOImageGen.ImageGenWorker worker) {
        if ((color & 0xFFFFFF) == 13055457) {
            IBlockState block = this.getBlockFromColor(color, random);
            if (block != null) {
                world.func_180501_a(pos, block, 3);
                this.onBlockPlace(world, block, pos, random, color, worker);
            }
        } else {
            super.placeBlock(world, color, pos, layer, random, placeNotify, worker);
        }
    }

    @Override
    public void onBlockPlace(World world, IBlockState state, BlockPos pos, Random random, int color, MOImageGen.ImageGenWorker worker) {
    }

    @Override
    public MOWorldGenBuilding.WorldGenBuildingWorker getNewWorkerInstance() {
        return new MOWorldGenBuilding.WorldGenBuildingWorker();
    }

    protected void onGeneration(Random random, World world, BlockPos pos, MOWorldGenBuilding.WorldGenBuildingWorker worker) {
    }

    @Override
    public boolean shouldGenerate(Random random, World world, BlockPos pos) {
        return world.func_180494_b(pos) == Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("minecraft", "desert"));
    }
}

