/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util.animation;

public class MOEasing {

    public static class Quart {
        public static float easeIn(float t, float b, float c, float d) {
            return c * (t /= d) * t * t * t + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return -c * (t * t * t * t - 1.0f) + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t * t * t + b;
            }
            return -c / 2.0f * ((t -= 2.0f) * t * t * t - 2.0f) + b;
        }
    }

    public static class Cubic {
        public static float easeIn(float t, float b, float c, float d) {
            return c * (t /= d) * t * t + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return c * (t * t * t + 1.0f) + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t * t + b;
            }
            return c / 2.0f * ((t -= 2.0f) * t * t + 2.0f) + b;
        }
    }

    public static class Elastic {
        public static float easeIn(float t, float b, float c, float d) {
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            float p = d * 0.3f;
            float s = p / 4.0f;
            return -(c * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
        }

        public static float easeIn(float t, float b, float c, float d, float a, float p) {
            float s;
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(c / a);
            }
            return -(a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((double)(t * d - s) * (Math.PI * 2) / (double)p)) + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            float p = d * 0.3f;
            float s = p / 4.0f;
            return c * (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) + c + b;
        }

        public static float easeOut(float t, float b, float c, float d, float a, float p) {
            float s;
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(c / a);
            }
            return a * (float)Math.pow(2.0, -10.0f * t) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) + c + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d / 2.0f) == 2.0f) {
                return b + c;
            }
            float p = d * 0.45000002f;
            float s = p / 4.0f;
            if (t < 1.0f) {
                return -0.5f * (c * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
            }
            return c * (float)Math.pow(2.0, -10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) * 0.5f + c + b;
        }

        public static float easeInOut(float t, float b, float c, float d, float a, float p) {
            float s;
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d / 2.0f) == 2.0f) {
                return b + c;
            }
            if (a < Math.abs(c)) {
                a = c;
                s = p / 4.0f;
            } else {
                s = p / ((float)Math.PI * 2) * (float)Math.asin(c / a);
            }
            if (t < 1.0f) {
                return -0.5f * (a * (float)Math.pow(2.0, 10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p)) + b;
            }
            return a * (float)Math.pow(2.0, -10.0f * (t -= 1.0f)) * (float)Math.sin((t * d - s) * ((float)Math.PI * 2) / p) * 0.5f + c + b;
        }
    }

    public static class Sine {
        public static float easeIn(float t, float b, float c, float d) {
            return -c * (float)Math.cos((double)(t / d) * 1.5707963267948966) + c + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            return c * (float)Math.sin((double)(t / d) * 1.5707963267948966) + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            return -c / 2.0f * ((float)Math.cos(Math.PI * (double)t / (double)d) - 1.0f) + b;
        }
    }

    public static class Bounce {
        public static float easeIn(float t, float b, float c, float d) {
            return c - Bounce.easeOut(d - t, 0.0f, c, d) + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            float f;
            t /= d;
            if (f < 0.36363637f) {
                return c * (7.5625f * t * t) + b;
            }
            if (t < 0.72727275f) {
                return c * (7.5625f * (t -= 0.54545456f) * t + 0.75f) + b;
            }
            if ((double)t < 0.9090909090909091) {
                return c * (7.5625f * (t -= 0.8181818f) * t + 0.9375f) + b;
            }
            return c * (7.5625f * (t -= 0.95454544f) * t + 0.984375f) + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            if (t < d / 2.0f) {
                return Bounce.easeIn(t * 2.0f, 0.0f, c, d) * 0.5f + b;
            }
            return Bounce.easeOut(t * 2.0f - d, 0.0f, c, d) * 0.5f + c * 0.5f + b;
        }
    }

    public static class Quad {
        public static float easeIn(float t, float b, float c, float d) {
            return c * (t /= d) * t + b;
        }

        public static float easeOut(float t, float b, float c, float d) {
            return -c * (t /= d) * (t - 2.0f) + b;
        }

        public static float easeInOut(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t + b;
            }
            return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
        }
    }
}

