/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.data.WeightedRandomItemStack;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.items.weapon.module.WeaponModuleBarrel;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;

public class WeaponFactory {
    public static final int MAX_LOOT_LEVEL = 3;
    public final List<WeightedRandomItemStack> weapons;
    public final List<WeightedRandomWeaponModule> barrelModules;
    public final List<WeightedRandomWeaponModule> batteryModules;
    public final List<WeightedRandomWeaponModule> otherModules;
    private final Random random = new Random();

    public WeaponFactory() {
        this.barrelModules = new ArrayList<WeightedRandomWeaponModule>();
        this.batteryModules = new ArrayList<WeightedRandomWeaponModule>();
        this.otherModules = new ArrayList<WeightedRandomWeaponModule>();
        this.weapons = new ArrayList<WeightedRandomItemStack>();
    }

    public static int getTotalModulesWeight(Collection<WeightedRandomWeaponModule> collection, WeaponGenerationContext context) {
        int i = 0;
        for (WeightedRandomWeaponModule module : collection) {
            if (!module.fits(context)) continue;
            i += module.field_76292_a;
        }
        return i;
    }

    public static WeightedRandomWeaponModule getItem(Collection<WeightedRandomWeaponModule> par1Collection, int weight, WeaponGenerationContext context) {
        int j = weight;
        Iterator<WeightedRandomWeaponModule> iterator = par1Collection.iterator();
        WeightedRandomWeaponModule module = null;
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            WeightedRandomWeaponModule temp = iterator.next();
            if (!temp.fits(context)) continue;
            module = temp;
            j -= temp.field_76292_a;
        } while (j >= 0);
        return module;
    }

    public static WeightedRandomWeaponModule getRandomModule(Random random, Collection collection, WeaponGenerationContext context) {
        return WeaponFactory.getItem(collection, random.nextInt(WeaponFactory.getTotalModulesWeight(collection, context) + 1), context);
    }

    public void initModules() {
        this.barrelModules.add(new WeightedRandomWeaponModule(null, 200, 0, 3));
        this.barrelModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_barrel, 1, 0), 100, 1, 3));
        this.barrelModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_barrel, 1, 1), 10, 1, 3));
        this.barrelModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_barrel, 1, 2), 5, 2, 3));
        this.batteryModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.battery), 100, 1, 3));
        this.batteryModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.hc_battery), 20, 1, 3));
        this.otherModules.add(new WeightedRandomWeaponModule(null, 300, 0, 3));
        this.otherModules.add(new WeightedRandomWeaponModule(new ItemStack((Item)MatterOverdrive.ITEMS.sniperScope), 10, 1, 3));
    }

    public void initWeapons() {
        this.weapons.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.phaserRifle), 70));
        this.weapons.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.omniTool), 30));
        this.weapons.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.plasmaShotgun), 10));
        this.weapons.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.ionSniper), 5));
    }

    public ItemStack getRandomDecoratedEnergyWeapon(WeaponGenerationContext context) {
        ItemStack weapon = this.getRandomEnergyWeapon(context);
        context.setWeaponStack(weapon);
        this.decorateWeapon(weapon, context);
        if (context.fullCharge) {
            ((EnergyContainer)EnergyWeapon.getStorage(weapon)).setFull();
        }
        return weapon;
    }

    public ItemStack getRandomEnergyWeapon(WeaponGenerationContext context) {
        ItemStack weapon = ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)this.random, this.weapons)).getStack();
        if (context.fullCharge) {
            ((EnergyContainer)EnergyWeapon.getStorage(weapon)).setFull();
        }
        return weapon;
    }

    public void decorateWeapon(ItemStack weapon, WeaponGenerationContext context) {
        WeightedRandomWeaponModule battery;
        WeightedRandomWeaponModule barrelModule = null;
        if (context.barrel && (barrelModule = WeaponFactory.getRandomModule(this.random, this.barrelModules, context)) != null && barrelModule.getWeaponModule() != null) {
            WeaponHelper.setModuleAtSlot(barrelModule.getModuleSlot(), weapon, barrelModule.getWeaponModule());
        }
        if (context.battery && (battery = WeaponFactory.getRandomModule(this.random, this.batteryModules, context)) != null && battery.getWeaponModule() != null) {
            WeaponHelper.setModuleAtSlot(battery.getModuleSlot(), weapon, battery.getWeaponModule());
        }
        if (context.other) {
            WeightedRandomWeaponModule other = WeaponFactory.getRandomModule(this.random, this.otherModules, context);
            if (other != null) {
                if (other.getWeaponModule() != null) {
                    WeaponHelper.setModuleAtSlot(other.getModuleSlot(), weapon, other.getWeaponModule());
                }
            } else if (barrelModule != null && barrelModule.weaponModule != null) {
                this.setColorModuleBasedOnBarrel(weapon, barrelModule.weaponModule);
            }
        }
        if (context.legendary) {
            this.modifyToLegendary(weapon, context);
        }
    }

    public void setColorModuleBasedOnBarrel(ItemStack weapon, ItemStack barrel) {
        if (barrel.func_77973_b() instanceof WeaponModuleBarrel) {
            if (barrel.func_77952_i() == 2) {
                WeaponHelper.setModuleAtSlot(1, weapon, new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_color, 1, 6));
            } else if (barrel.func_77952_i() == 1) {
                WeaponHelper.setModuleAtSlot(1, weapon, new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_color, 1));
            } else if (barrel.func_77952_i() == 0) {
                WeaponHelper.setModuleAtSlot(1, weapon, new ItemStack((Item)MatterOverdrive.ITEMS.weapon_module_color, 1, 2));
            }
        }
    }

    public void modifyToLegendary(ItemStack weapon, WeaponGenerationContext context) {
        int rangeLevel;
        int shootCooldownLevel;
        int accuracyLevel;
        weapon.func_151001_c("\u272a " + TextFormatting.GOLD + MOStringHelper.translateToLocal("rarity.legendary", new Object[0]) + " " + weapon.func_82833_r());
        int damageLevel = this.random.nextInt(context.level + 1);
        if (damageLevel > 0) {
            weapon.func_77978_p().func_74776_a("CustomDamageMultiply", 1.0f + 0.1f * (float)damageLevel);
        }
        if ((accuracyLevel = this.random.nextInt(context.level + 1)) > 0) {
            weapon.func_77978_p().func_74776_a("CustomAccuracyMultiply", 1.0f - 0.1f * (float)accuracyLevel);
        }
        if ((shootCooldownLevel = this.random.nextInt(context.level + 1)) > 0) {
            weapon.func_77978_p().func_74776_a("CustomSpeedMultiply", 1.0f - 0.05f * (float)shootCooldownLevel);
        }
        if ((rangeLevel = this.random.nextInt(context.level + 1)) > 0) {
            weapon.func_77978_p().func_74776_a("CustomRangeMultiply", 1.0f + 0.15f * (float)rangeLevel);
        }
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public static class WeightedRandomWeaponModule
    extends WeightedRandom.Item {
        private final ItemStack weaponModule;
        private int minLevel;
        private int maxLevel;
        private boolean legendary;
        private int slotID;

        public WeightedRandomWeaponModule(ItemStack weaponModule, int weight, int minLevel, int maxLevel) {
            super(weight);
            if (weaponModule != null) {
                if (weaponModule.func_77973_b() instanceof IWeaponModule) {
                    this.slotID = ((IWeaponModule)weaponModule.func_77973_b()).getSlot(weaponModule);
                } else if (weaponModule.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    this.slotID = 0;
                }
            }
            this.weaponModule = weaponModule;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public int getModuleSlot() {
            return this.slotID;
        }

        @Nonnull
        public ItemStack getWeaponModule() {
            if (this.weaponModule != null) {
                return this.weaponModule.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }

        public boolean fits(WeaponGenerationContext context) {
            if (this.weaponModule == null || this.weaponModule.func_190926_b()) {
                return false;
            }
            boolean weaponSupportModule = false;
            if (context.weaponStack != null && !context.weaponStack.func_190926_b() && context.weaponStack.func_77973_b() instanceof IWeapon) {
                boolean bl = weaponSupportModule = context.weaponStack.func_77973_b() instanceof IWeapon && ((IWeapon)context.weaponStack.func_77973_b()).supportsModule(context.weaponStack, this.weaponModule);
            }
            if (this.legendary && !context.legendary) {
                return weaponSupportModule;
            }
            return context.level >= this.minLevel && context.level <= this.maxLevel && weaponSupportModule;
        }
    }

    public static class WeaponGenerationContext {
        public final int level;
        public Entity entity;
        public boolean legendary;
        public boolean fullCharge = true;
        public boolean barrel = true;
        public boolean battery = true;
        public boolean other = true;
        public ItemStack weaponStack;

        public WeaponGenerationContext(int level) {
            this.level = level;
        }

        public WeaponGenerationContext(int level, Entity entity) {
            this(level);
            this.entity = entity;
        }

        public WeaponGenerationContext(int level, Entity entity, boolean legendary) {
            this(level, entity);
            this.legendary = legendary;
        }

        public void setWeaponStack(ItemStack weaponStack) {
            this.weaponStack = weaponStack;
        }
    }
}

