/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.data.MatterStorage;
import matteroverdrive.data.transport.FluidPipeNetwork;
import matteroverdrive.data.transport.IFluidPipe;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketMatterUpdate;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.TimeTracker;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityMatterPipe
extends TileEntityPipe
implements IFluidPipe {
    public static Random rand = new Random();
    protected final MatterStorage storage;
    protected FluidPipeNetwork fluidPipeNetwork;
    protected int transferSpeed = 10;
    TimeTracker t = new TimeTracker();

    public TileEntityMatterPipe() {
        this.storage = new MatterStorage(32);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.manageTransfer();
            this.manageNetwork();
        }
    }

    public void manageNetwork() {
        if (this.fluidPipeNetwork == null && !this.tryConnectToNeighborNetworks(this.field_145850_b)) {
            FluidPipeNetwork network = (FluidPipeNetwork)MatterOverdrive.FLUID_NETWORK_HANDLER.getNetwork(this);
            network.addNode(this);
        }
    }

    public void manageTransfer() {
        if (this.storage.getMatterStored() > 0 && this.getNetwork() != null) {
            for (IFluidPipe pipe : this.getNetwork().getNodes()) {
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    TileEntity handler = pipe.getTile().func_145831_w().func_175625_s(pipe.getTile().func_174877_v().func_177972_a(direction));
                    if (handler == null || !handler.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()) || handler instanceof IFluidPipe) continue;
                    int amount = this.storage.extractMatter(((IFluidHandler)handler.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())).fill(new FluidStack((Fluid)OverdriveFluids.matterPlasma, this.storage.getMatterStored()), true), false);
                    if (amount != 0) {
                        MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketMatterUpdate(handler), handler, 64.0);
                    }
                    if (this.storage.getMatterStored() > 0) continue;
                    return;
                }
            }
        }
    }

    @Override
    public boolean canConnectToPipe(TileEntity entity, EnumFacing direction) {
        if (entity != null) {
            if (entity instanceof TileEntityMatterPipe) {
                return this.func_145838_q() == entity.func_145838_q();
            }
            return entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (!this.field_145850_b.field_72995_K && categories.contains((Object)MachineNBTCategory.DATA) && toDisk) {
            this.storage.writeToNBT(comp);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.storage.readFromNBT(comp);
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onAdded(World world, BlockPos pos, IBlockState state) {
    }

    public boolean tryConnectToNeighborNetworks(World world) {
        boolean hasConnected = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity neighborEntity = world.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (!(neighborEntity instanceof TileEntityMatterPipe) || this.func_145838_q() != neighborEntity.func_145838_q() || ((TileEntityMatterPipe)neighborEntity).getNetwork() == null || ((TileEntityMatterPipe)neighborEntity).getNetwork() == this.fluidPipeNetwork) continue;
            ((TileEntityMatterPipe)neighborEntity).getNetwork().addNode(this);
            hasConnected = true;
        }
        return hasConnected;
    }

    @Override
    public void onDestroyed(World worldIn, BlockPos pos, IBlockState state) {
        if (this.fluidPipeNetwork != null) {
            this.fluidPipeNetwork.onNodeDestroy(state, this);
        }
    }

    @Override
    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.updateSides(true);
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public FluidPipeNetwork getNetwork() {
        return this.fluidPipeNetwork;
    }

    @Override
    public void setNetwork(FluidPipeNetwork network) {
        this.fluidPipeNetwork = network;
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return toNode instanceof TileEntityMatterPipe;
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        return true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == MatterOverdriveCapabilities.MATTER_HANDLER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == MatterOverdriveCapabilities.MATTER_HANDLER) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }
}

