/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.data.Inventory;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.GalaxyServer;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineStarMap
extends MOTileEntityMachineEnergy {
    GalacticPosition position = new GalacticPosition();
    GalacticPosition destination = new GalacticPosition();
    int zoomLevel;

    public TileEntityMachineStarMap() {
        super(0);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        super.RegisterSlots(inventory);
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.getInventory() != this.inventory) {
            this.getInventory().func_70296_d();
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74774_a("ZoomLevel", (byte)this.zoomLevel);
            NBTTagCompound positionTag = new NBTTagCompound();
            NBTTagCompound destinationTag = new NBTTagCompound();
            this.position.writeToNBT(positionTag);
            this.destination.writeToNBT(destinationTag);
            nbt.func_74782_a("GalacticPosition", (NBTBase)positionTag);
            nbt.func_74782_a("GalacticDestination", (NBTBase)destinationTag);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.zoomLevel = nbt.func_74771_c("ZoomLevel");
            GalacticPosition newPosition = new GalacticPosition(nbt.func_74775_l("GalacticPosition"));
            GalacticPosition newDestination = new GalacticPosition(nbt.func_74775_l("GalacticDestination"));
            this.position = newPosition;
            this.destination = newDestination;
        }
    }

    public void zoom() {
        if (this.getZoomLevel() < this.getMaxZoom()) {
            this.setZoomLevel(this.getZoomLevel() + 1);
        } else {
            this.setZoomLevel(0);
        }
        this.forceSync();
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 3), (double)(this.func_174877_v().func_177956_o() + 5), (double)(this.func_174877_v().func_177952_p() + 3));
    }

    @Override
    public IInventory getInventory() {
        if (this.getPlanet() != null) {
            return this.getPlanet();
        }
        return this.inventory;
    }

    public Planet getPlanet() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getPlanet(this.destination);
        }
        return GalaxyServer.getInstance().getPlanet(this.destination);
    }

    public Star getStar() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getStar(this.destination);
        }
        return GalaxyServer.getInstance().getStar(this.destination);
    }

    public Quadrant getQuadrant() {
        if (this.field_145850_b.field_72995_K) {
            return GalaxyClient.getInstance().getQuadrant(this.destination);
        }
        return GalaxyServer.getInstance().getQuadrant(this.destination);
    }

    public int getMaxZoom() {
        if (this.getPlanet() != null) {
            return 3;
        }
        return 2;
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
        if (event instanceof MachineEvent.Placed) {
            MachineEvent.Placed placed = (MachineEvent.Placed)event;
            if (placed.entityLiving instanceof EntityPlayer) {
                if (placed.world.field_72995_K) {
                    Planet homeworld = GalaxyClient.getInstance().getHomeworld((EntityPlayer)placed.entityLiving);
                    if (homeworld != null) {
                        this.position = new GalacticPosition(homeworld);
                    }
                } else {
                    Planet homeworld = GalaxyServer.getInstance().getHomeworld((EntityPlayer)placed.entityLiving);
                    if (homeworld != null) {
                        this.position = new GalacticPosition(homeworld);
                    }
                }
                this.destination = new GalacticPosition(this.position);
                this.owner = ((EntityPlayer)placed.entityLiving).func_146103_bH().getId();
            }
        }
    }

    public GalacticPosition getGalaxyPosition() {
        return this.position;
    }

    public void setGalaxticPosition(GalacticPosition position) {
        this.position = position;
    }

    public GalacticPosition getDestination() {
        return this.destination;
    }

    public void setDestination(GalacticPosition position) {
        this.destination = position;
    }

    public SpaceBody getActiveSpaceBody() {
        switch (this.getZoomLevel()) {
            case 0: {
                return GalaxyClient.getInstance().getTheGalaxy();
            }
            case 1: {
                return GalaxyClient.getInstance().getQuadrant(this.destination);
            }
            case 2: {
                return GalaxyClient.getInstance().getStar(this.destination);
            }
        }
        return GalaxyClient.getInstance().getPlanet(this.destination);
    }

    public boolean isItemValidForSlot(int slot, ItemStack item, EntityPlayer player) {
        return (this.getPlanet() == null || this.getPlanet().isOwner(player)) && this.getInventory().func_94041_b(slot, item);
    }

    public void onItemPickup(EntityPlayer player, ItemStack itemStack) {
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    public void onItemPlaced(ItemStack itemStack) {
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }
}

