/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.awt.Color;
import javax.annotation.Nonnull;
import matteroverdrive.api.gravity.AnomalySuppressor;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.blocks.BlockGravitationalAnomaly;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.fx.GravitationalStabilizerBeamParticle;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityMachineGravitationalStabilizer
extends MOTileEntityMachineEnergy
implements IMOTickable {
    public static Color color1 = new Color(0xFFFFFF);
    public static Color color2 = new Color(0xFF0000);
    public static Color color3 = new Color(1137284);
    RayTraceResult hit;

    public TileEntityMachineGravitationalStabilizer() {
        super(4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(this.field_145850_b);
            this.hit = this.seacrhForAnomalies(this.field_145850_b);
        }
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    RayTraceResult seacrhForAnomalies(World world) {
        EnumFacing front = ((EnumFacing)world.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)).func_176734_d();
        for (int i = 1; i < 64; ++i) {
            IBlockState blockState = world.func_180495_p(this.func_174877_v().func_177967_a(front, i));
            if (!(blockState.func_177230_c() instanceof BlockGravitationalAnomaly) && !blockState.func_185904_a().func_76218_k()) continue;
            return new RayTraceResult(new Vec3d((Vec3i)this.func_174877_v().func_177967_a(front, i)).func_178786_a(Math.abs((double)front.func_176730_m().func_177958_n() * 0.5), Math.abs((double)front.func_176730_m().func_177956_o() * 0.5), Math.abs((double)front.func_176730_m().func_177952_p() * 0.5)), front.func_176734_d(), this.func_174877_v().func_177967_a(front, i));
        }
        return null;
    }

    void manageAnomalies(World world) {
        this.hit = this.seacrhForAnomalies(world);
        if (this.hit != null && world.func_175625_s(this.hit.func_178782_a()) instanceof TileEntityGravitationalAnomaly) {
            ((TileEntityGravitationalAnomaly)world.func_175625_s(this.hit.func_178782_a())).suppress(new AnomalySuppressor(this.func_174877_v(), 20, 0.7f));
        }
    }

    public float getPercentage() {
        TileEntity tile;
        if (this.hit != null && (tile = this.field_145850_b.func_175625_s(this.hit.func_178782_a())) instanceof TileEntityGravitationalAnomaly) {
            return Math.max(0.0f, Math.min((float)(((TileEntityGravitationalAnomaly)tile).getEventHorizon() - (double)0.3f) / 2.3f, 1.0f));
        }
        return -1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    void spawnParticles(World world) {
        if (this.hit != null && world.func_175625_s(this.hit.func_178782_a()) instanceof TileEntityGravitationalAnomaly && random.nextFloat() < 0.3f) {
            float r = (float)this.getParticleColorR();
            float g = (float)this.getParticleColorG();
            float b = (float)this.getParticleColorB();
            EnumFacing up = MOBlockHelper.getAboveSide((EnumFacing)world.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)).func_176734_d();
            GravitationalStabilizerBeamParticle particle = new GravitationalStabilizerBeamParticle(world, new Vector3f((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 0.5f, (float)this.func_174877_v().func_177952_p() + 0.5f), new Vector3f((float)this.hit.func_178782_a().func_177958_n() + 0.5f, (float)this.hit.func_178782_a().func_177956_o() + 0.5f, (float)this.hit.func_178782_a().func_177952_p() + 0.5f), new Vector3f((float)up.func_82601_c(), (float)up.func_96559_d(), (float)up.func_82599_e()), 1.0f, 0.3f, 80);
            particle.setColor(r, g, b, 1.0f);
            ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(particle, RenderParticlesHandler.Blending.Additive);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 8172.0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = Block.field_185505_j.func_186670_a(this.func_174877_v());
        if (this.hit != null) {
            return bb.func_72321_a((double)(this.hit.func_178782_a().func_177958_n() - this.func_174877_v().func_177958_n()), (double)(this.hit.func_178782_a().func_177956_o() - this.func_174877_v().func_177956_o()), (double)(this.hit.func_178782_a().func_177952_p() - this.func_174877_v().func_177952_p()));
        }
        return bb;
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.forceField;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.hit != null;
    }

    @Override
    public float soundVolume() {
        return this.getPercentage() * 0.5f;
    }

    public double getBeamColorR() {
        float percent = this.getPercentage();
        if (percent == -1.0f) {
            return color3.getRed();
        }
        return ((float)color2.getRed() * percent + (float)color1.getRed() * (1.0f - percent)) / 255.0f;
    }

    public double getBeamColorG() {
        float percent = this.getPercentage();
        if (percent == -1.0f) {
            return color3.getGreen();
        }
        return ((float)color2.getGreen() * percent + (float)color1.getGreen() * (1.0f - percent)) / 255.0f;
    }

    public double getBeamColorB() {
        float percent = this.getPercentage();
        if (percent == -1.0f) {
            return color3.getBlue();
        }
        return ((float)color2.getBlue() * percent + (float)color1.getBlue() * (1.0f - percent)) / 255.0f;
    }

    public double getParticleColorR() {
        return this.getBeamColorR();
    }

    public double getParticleColorG() {
        return this.getBeamColorG();
    }

    public double getParticleColorB() {
        return this.getBeamColorB();
    }

    public RayTraceResult getHit() {
        return this.hit;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void onServerTick(TickEvent.Phase phase, World world) {
        if (world == null) {
            return;
        }
        if (phase.equals((Object)TickEvent.Phase.START) && this.getRedstoneActive()) {
            this.manageAnomalies(world);
        }
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }
}

