/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.Optional;
import javax.annotation.Nullable;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBoundingBox
extends TileEntity
implements IMOTileEntity,
ITickable {
    private int tick = 0;
    private BlockPos ownerPos;
    private Block ownerBlock;

    public void func_73660_a() {
        ++this.tick;
        if (this.tick == 80) {
            this.tick = 0;
            if (this.field_145850_b != null && !this.ownerPresent()) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
        }
    }

    private boolean ownerPresent() {
        if (this.ownerPos != null) {
            return this.field_145850_b.func_180495_p(this.ownerPos).func_177230_c() == this.ownerBlock;
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerPos = BlockPos.func_177969_a((long)tag.func_74763_f("owner"));
        String ownerModid = tag.func_74779_i("owner_block_modid");
        String ownerName = tag.func_74779_i("owner_block_name");
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(ownerModid, ownerName));
        if (block == null) {
            MOLog.error("Missing owner block " + ownerModid + ":" + ownerName, new Object[0]);
        } else {
            this.ownerBlock = block;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.ownerPos != null) {
            tag.func_74772_a("owner", this.ownerPos.func_177986_g());
        }
        if (this.ownerBlock != null) {
            ResourceLocation id = this.ownerBlock.getRegistryName();
            tag.func_74778_a("owner_block_modid", id.func_110624_b());
            tag.func_74778_a("owner_block_name", id.func_110623_a());
        }
        return tag;
    }

    public BlockPos getOwnerPos() {
        return this.ownerPos;
    }

    public void setOwnerPos(BlockPos ownerPos) {
        this.ownerPos = ownerPos;
    }

    public Block getOwnerBlock() {
        return this.ownerBlock;
    }

    public void setOwnerBlock(Block ownerBlock) {
        this.ownerBlock = ownerBlock;
    }

    public Optional<TileEntity> getOwnerTile() {
        return Optional.ofNullable(this.field_145850_b.func_175625_s(this.getOwnerPos()));
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public void onAdded(World world, BlockPos pos, IBlockState state) {
    }

    @Override
    public void onDestroyed(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Override
    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getOwnerTile().map(tile -> tile.hasCapability(capability, facing)).orElseGet(() -> super.hasCapability(capability, facing));
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)this.getOwnerTile().map(tile -> tile.getCapability(capability, facing)).orElseGet(() -> super.getCapability(capability, facing));
    }
}

