/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.MachineEnergyStorage;
import matteroverdrive.data.inventory.EnergySlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketPowerUpdate;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public abstract class MOTileEntityMachineEnergy
extends MOTileEntityMachine {
    public static final int ENERGY_CLIENT_SYNC_RANGE = 16;
    protected MachineEnergyStorage energyStorage = new MachineEnergyStorage<MOTileEntityMachineEnergy>(512, 512, 512, this);
    protected int energySlotID;

    public MOTileEntityMachineEnergy(int upgradeCount) {
        super(upgradeCount);
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.energySlotID = inventory.AddSlot(new EnergySlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            NBTTagCompound energy = this.energyStorage.serializeNBT();
            nbt.func_74782_a("Energy", (NBTBase)energy);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.energyStorage.deserializeNBT(nbt.func_74775_l("Energy"));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.manageCharging();
    }

    protected void manageCharging() {
        if (this.isCharging() && !this.field_145850_b.field_72995_K) {
            int emptyEnergySpace = this.getFreeEnergySpace();
            int maxEnergyCanSpare = MOEnergyHelper.extractEnergyFromContainer(this.inventory.func_70301_a(this.energySlotID), emptyEnergySpace, true);
            if (emptyEnergySpace > 0 && maxEnergyCanSpare > 0) {
                this.getEnergyStorage().receiveEnergy(MOEnergyHelper.extractEnergyFromContainer(this.inventory.func_70301_a(this.energySlotID), emptyEnergySpace, false), false);
            }
        }
    }

    public boolean isCharging() {
        return !this.inventory.func_70301_a(this.energySlotID).func_190926_b() && MOEnergyHelper.isEnergyContainerItem(this.inventory.func_70301_a(this.energySlotID)) && ((IEnergyStorage)this.inventory.func_70301_a(this.energySlotID).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(this.getFreeEnergySpace(), true) > 0;
    }

    public int getEnergySlotID() {
        return this.energySlotID;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getFreeEnergySpace() {
        return this.getEnergyStorage().getMaxEnergyStored() - this.getEnergyStorage().getEnergyStored();
    }

    public void UpdateClientPower() {
        MatterOverdrive.NETWORK.sendToAllAround(new PacketPowerUpdate(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0));
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (itemStack != null && itemStack.func_77942_o()) {
            this.energyStorage.deserializeNBT(itemStack.func_77978_p().func_74775_l("Energy"));
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (itemStack != null && this.energyStorage.getEnergyStored() > 0) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound energy = this.energyStorage.serializeNBT();
            itemStack.func_77978_p().func_74782_a("Energy", (NBTBase)energy);
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.energyStorage) : super.getCapability(capability, facing));
    }
}

