/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.data.biostats.BioticStatTeleport;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTeleportPlayer
extends PacketAbstract {
    double x;
    double y;
    double z;

    public PacketTeleportPlayer() {
    }

    public PacketTeleportPlayer(Vec3d vec3) {
        this.x = vec3.field_72450_a;
        this.y = vec3.field_72448_b;
        this.z = vec3.field_72449_c;
    }

    public PacketTeleportPlayer(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketTeleportPlayer> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketTeleportPlayer message, MessageContext ctx) {
            int unlockedLevel;
            AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player);
            if (androidPlayer != null && androidPlayer.isAndroid() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(OverdriveBioticStats.teleport, unlockedLevel = androidPlayer.getUnlockedLevel(OverdriveBioticStats.teleport), androidPlayer)) && OverdriveBioticStats.teleport.isEnabled(androidPlayer, unlockedLevel)) {
                MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSpawnParticle("teleport", player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 1, RenderParticlesHandler.Blending.Additive), (EntityPlayer)player, 64.0);
                player.field_70170_p.func_184148_a((EntityPlayer)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, MatterOverdriveSounds.androidTeleport, SoundCategory.BLOCKS, 0.2f, 0.8f + 0.4f * player.field_70170_p.field_73012_v.nextFloat());
                player.func_70634_a(message.x, message.y, message.z);
                player.field_70170_p.func_184148_a(null, message.x, message.y, message.z, MatterOverdriveSounds.androidTeleport, SoundCategory.BLOCKS, 0.2f, 0.8f + 0.4f * player.field_70170_p.field_73012_v.nextFloat());
                androidPlayer.getAndroidEffects().updateEffect(6, player.field_70170_p.func_82737_E() + 40L);
                androidPlayer.getAndroidEffects().updateEffect(0, 5);
                androidPlayer.extractEnergyScaled(BioticStatTeleport.ENERGY_PER_TELEPORT);
                androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
                androidPlayer.getPlayer().field_70143_R = 0.0f;
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = androidPlayer.getPlayer().field_71071_by.func_70301_a(i);
                    CooldownTracker tracker = androidPlayer.getPlayer().func_184811_cZ();
                    if (tracker.func_185141_a(stack.func_77973_b()) && !(tracker.func_185143_a(stack.func_77973_b(), 0.0f) < 40.0f)) continue;
                    tracker.func_185145_a(stack.func_77973_b(), 40);
                }
            }
        }
    }
}

