/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.PacketAbstract;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketManageConversation
extends PacketAbstract {
    public boolean start;
    public int npcID;

    public PacketManageConversation() {
    }

    public PacketManageConversation(IDialogNpc npc, boolean start) {
        this.npcID = npc.getEntity().func_145782_y();
        this.start = start;
    }

    public void fromBytes(ByteBuf buf) {
        this.npcID = buf.readInt();
        this.start = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.npcID);
        buf.writeBoolean(this.start);
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketManageConversation> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketManageConversation message, MessageContext ctx) {
            Entity npcEntity = player.field_70170_p.func_73045_a(message.npcID);
            if (npcEntity instanceof IDialogNpc) {
                if (message.start) {
                    ((IDialogNpc)npcEntity).onPlayerInteract((EntityPlayer)player, null);
                    ((IDialogNpc)npcEntity).setDialogPlayer((EntityPlayer)player);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDialog((IDialogNpc)npcEntity, (EntityPlayer)player));
                } else {
                    ((IDialogNpc)npcEntity).setDialogPlayer(null);
                }
            }
        }

        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketManageConversation message, MessageContext ctx) {
            Entity npcEntity = player.field_70170_p.func_73045_a(message.npcID);
            if (npcEntity instanceof IDialogNpc) {
                if (message.start) {
                    if (((IDialogNpc)npcEntity).getDialogPlayer() == null && ((IDialogNpc)npcEntity).canTalkTo((EntityPlayer)player)) {
                        ((IDialogNpc)npcEntity).setDialogPlayer((EntityPlayer)player);
                        MatterOverdrive.NETWORK.sendTo(message, player);
                    }
                } else {
                    ((IDialogNpc)npcEntity).setDialogPlayer(null);
                    MatterOverdrive.NETWORK.sendTo(message, player);
                }
            }
        }
    }
}

