/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.util.MOLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDigBlock
extends PacketAbstract {
    Type type;
    BlockPos pos;
    EnumFacing side;

    public PacketDigBlock() {
        this.pos = new BlockPos(0, 0, 0);
    }

    public PacketDigBlock(BlockPos pos, Type type, EnumFacing side) {
        if (pos == null) {
            MOLog.error("Empty Pos", new Object[0]);
        }
        this.pos = pos;
        this.side = side;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.side = EnumFacing.field_82609_l[buf.readByte()];
        this.type = Type.values()[buf.readByte()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeByte(this.side.ordinal());
        buf.writeByte(this.type.ordinal());
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketDigBlock> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketDigBlock message, MessageContext ctx) {
            WorldServer world = player.func_184102_h().func_71218_a(player.field_71093_bK);
            IBlockState state = world.func_180495_p(message.pos);
            switch (message.type) {
                case CLICK: {
                    if (!player.func_184102_h().func_175579_a((World)world, message.pos, (EntityPlayer)player)) {
                        player.field_71134_c.func_180784_a(message.pos, message.side);
                        break;
                    }
                    player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((World)world, message.pos));
                    break;
                }
                case HARVEST: {
                    player.field_71134_c.func_180237_b(message.pos);
                    if (state.func_185904_a() == Material.field_151579_a) break;
                    player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((World)world, message.pos));
                    break;
                }
                case CANCEL: {
                    player.field_71134_c.func_180238_e();
                    if (state.func_185904_a() == Material.field_151579_a) break;
                    player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((World)world, message.pos));
                }
            }
        }
    }

    public static enum Type {
        CLICK,
        CANCEL,
        HARVEST;

    }
}

