/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.items.DataPad;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDataPadCommands
extends PacketAbstract {
    public static final int COMMAND_ORDERING = 1;
    NBTTagCompound data;
    int command;
    EnumHand hand;

    public PacketDataPadCommands() {
    }

    public PacketDataPadCommands(EnumHand hand, ItemStack dataPad) {
        this(hand, dataPad, 0);
    }

    public PacketDataPadCommands(EnumHand hand, ItemStack dataPad, int command) {
        this.data = new NBTTagCompound();
        if (dataPad != null && dataPad.func_77942_o() && command == 0) {
            this.data = dataPad.func_77978_p();
        }
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        this.command = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.command);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketDataPadCommands> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketDataPadCommands message, MessageContext ctx) {
            ItemStack dataPadStack = player.func_184586_b(message.hand);
            if (dataPadStack != null && dataPadStack.func_77973_b() instanceof DataPad && message.command == 0) {
                dataPadStack.func_77982_d(message.data);
            }
        }
    }
}

