/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import io.netty.buffer.ByteBuf;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketMatterUpdate
extends TileEntityUpdatePacket {
    private int matter = 0;

    public PacketMatterUpdate() {
    }

    public PacketMatterUpdate(TileEntity tileentity) {
        super(tileentity.func_174877_v());
        this.matter = ((IMatterHandler)tileentity.getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null)).getMatterStored();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.matter = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.matter);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketMatterUpdate> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketMatterUpdate message, MessageContext ctx) {
            TileEntity tileEntity;
            if (player != null && player.field_70170_p != null && (tileEntity = player.field_70170_p.func_175625_s(message.pos)) != null && tileEntity.hasCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null)) {
                ((IMatterHandler)tileEntity.getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null)).setMatterStored(message.matter);
            }
        }
    }
}

