/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.bi;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.PacketAbstract;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketFirePlasmaShot
extends PacketAbstract {
    WeaponShot shot;
    private int sender;
    private Vec3d position;
    private Vec3d direction;

    public PacketFirePlasmaShot() {
    }

    public PacketFirePlasmaShot(int sender, Vec3d pos, Vec3d dir, WeaponShot shot) {
        this.shot = shot;
        this.sender = sender;
        this.position = pos;
        this.direction = dir;
    }

    public void fromBytes(ByteBuf buf) {
        this.shot = new WeaponShot(buf);
        this.sender = buf.readInt();
        this.position = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.direction = new Vec3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
    }

    public void toBytes(ByteBuf buf) {
        this.shot.writeTo(buf);
        buf.writeInt(this.sender);
        buf.writeDouble(this.position.field_72450_a);
        buf.writeDouble(this.position.field_72448_b);
        buf.writeDouble(this.position.field_72449_c);
        buf.writeFloat((float)this.direction.field_72450_a);
        buf.writeFloat((float)this.direction.field_72448_b);
        buf.writeFloat((float)this.direction.field_72449_c);
    }

    public WeaponShot getShot() {
        return this.shot;
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketFirePlasmaShot> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketFirePlasmaShot message, MessageContext ctx) {
            EntityLivingBase livingBase;
            Entity entity;
            if (player.func_145782_y() != message.sender && (entity = player.field_70170_p.func_73045_a(message.sender)) != null && entity instanceof EntityLivingBase && !(livingBase = (EntityLivingBase)entity).func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && livingBase.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof EnergyWeapon) {
                ((EnergyWeapon)livingBase.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).onClientShot(livingBase.func_184586_b(EnumHand.MAIN_HAND), livingBase, message.position, message.direction, message.shot);
            }
        }

        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketFirePlasmaShot message, MessageContext ctx) {
            this.handleServerShot((EntityPlayer)player, message, 0);
            MatterOverdrive.NETWORK.sendToAllAround((IMessage)message, (EntityPlayer)player, (double)(message.shot.getRange() + 64));
        }

        public void handleServerShot(EntityPlayer player, PacketFirePlasmaShot shot, int delay) {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem != null && heldItem.func_77973_b() instanceof EnergyWeapon && ((EnergyWeapon)heldItem.func_77973_b()).canFire(player.func_184586_b(EnumHand.MAIN_HAND), player.field_70170_p, (EntityLivingBase)player)) {
                ((EnergyWeapon)heldItem.func_77973_b()).onServerFire(heldItem, (EntityLivingBase)player, shot.shot, shot.position, shot.direction, delay);
            }
        }
    }
}

