/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.pattern_storage;

import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.blocks.BlockPatternStorage;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DatabaseSlot;
import matteroverdrive.data.inventory.PatternStorageSlot;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.data.matter_network.MatterDatabaseEvent;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.pattern_storage.ComponentMatterNetworkPatternStorage;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.components.TaskQueueComponent;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class TileEntityMachinePatternStorage
extends MOTileEntityMachineEnergy
implements IMatterNetworkClient,
IMatterDatabase,
IScannable,
IMatterNetworkConnection,
IMatterNetworkDispatcher {
    public static final int TASK_PROCESS_DELAY = 40;
    private static final EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.PowerStorage, UpgradeTypes.PowerUsage);
    public static int ENERGY_CAPACITY = 64000;
    public static int ENERGY_TRANSFER = 128;
    public int input_slot;
    public int[] pattern_storage_slots;
    private ComponentMatterNetworkPatternStorage networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;
    private TaskQueueComponent<MatterNetworkTaskReplicatePattern, TileEntityMachinePatternStorage> taskQueueComponent;

    public TileEntityMachinePatternStorage() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_CAPACITY);
        this.energyStorage.setMaxExtract(ENERGY_TRANSFER);
        this.energyStorage.setMaxReceive(ENERGY_TRANSFER);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStorage.getEnergyStored() > 0) {
                this.manageLinking();
            }
        } else if (this.isActive() && random.nextFloat() < 0.2f && this.getBlockType(BlockPatternStorage.class) != null && this.getBlockType(BlockPatternStorage.class).hasVentParticles && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == MatterOverdrive.BLOCKS.pattern_storage) {
            this.SpawnVentParticles(0.03f, ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)).func_176734_d(), 1);
        }
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.pattern_storage_slots = new int[6];
        this.input_slot = inventory.AddSlot(new DatabaseSlot(true));
        for (int i = 0; i < this.pattern_storage_slots.length; ++i) {
            this.pattern_storage_slots[i] = inventory.AddSlot(new PatternStorageSlot(false, this, i));
        }
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new ComponentMatterNetworkPatternStorage(this);
        this.taskQueueComponent = new TaskQueueComponent("Tasks", this, 1, 0);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
        this.addComponent(this.taskQueueComponent);
    }

    protected void manageLinking() {
        if (MatterHelper.isMatterScanner(this.inventory.func_70301_a(this.input_slot))) {
            MatterScanner.link(this.field_145850_b, this.func_174877_v(), this.inventory.func_70301_a(this.input_slot));
        }
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        int patternCount = 0;
        for (ItemStack patternDrive : this.getPatternStorageList()) {
            if (patternDrive == null || !(patternDrive.func_77973_b() instanceof IMatterPatternStorage)) continue;
            int capacity = ((IMatterPatternStorage)patternDrive.func_77973_b()).getCapacity(patternDrive);
            for (int i = 0; i < capacity; ++i) {
                ItemPattern pattern = ((IMatterPatternStorage)patternDrive.func_77973_b()).getPatternAt(patternDrive, i);
                if (pattern == null) continue;
                ++patternCount;
            }
        }
        if (patternCount > 0) {
            infos.add(patternCount + "xPatterns");
        } else {
            infos.add("No Patterns.");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
    }

    @Override
    public boolean hasItem(ItemStack item) {
        for (int slotID : this.pattern_storage_slots) {
            ItemStack storageStack = this.inventory.func_70301_a(slotID);
            if (!MatterHelper.isMatterPatternStorage(storageStack)) continue;
            IMatterPatternStorage storage = (IMatterPatternStorage)storageStack.func_77973_b();
            for (int i = 0; i < storage.getCapacity(storageStack); ++i) {
                ItemPattern pattern = storage.getPatternAt(storageStack, i);
                if (pattern == null || !pattern.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addItem(ItemStack itemStack, int amount, boolean simulate, StringBuilder info) {
        ItemPattern pattern;
        int i;
        IMatterPatternStorage storage;
        ItemStack storageStack;
        if (!MatterHelper.CanScan(itemStack)) {
            if (info != null) {
                info.append(String.format("%s%s cannot be analyzed!", TextFormatting.RED, itemStack.func_82833_r()));
            }
            return false;
        }
        for (int p = 0; p < this.pattern_storage_slots.length; ++p) {
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(this.pattern_storage_slots[p]))) continue;
            storageStack = this.inventory.func_70301_a(this.pattern_storage_slots[p]);
            storage = (IMatterPatternStorage)storageStack.func_77973_b();
            for (i = 0; i < storage.getCapacity(storageStack); ++i) {
                pattern = storage.getPatternAt(storageStack, i);
                if (pattern == null || !pattern.equals(itemStack)) continue;
                if (pattern.getProgress() < 100) {
                    if (!simulate) {
                        pattern.setProgress(MathHelper.func_76125_a((int)(pattern.getProgress() + amount), (int)0, (int)100));
                        storage.setItemPatternAt(storageStack, i, pattern);
                        if (this.getNetwork() != null) {
                            this.getNetwork().post(new MatterDatabaseEvent.PatternChanged(this, p, i));
                        }
                    }
                    if (info != null) {
                        info.append(String.format("%s added to Pattern Storage. Progress is now at %s", TextFormatting.GREEN + itemStack.func_82833_r(), pattern.getProgress() + "%"));
                    }
                    return true;
                }
                if (info != null) {
                    info.append(String.format("%s is fully analyzed!", TextFormatting.RED + itemStack.func_82833_r()));
                }
                return false;
            }
        }
        for (int s = 0; s < this.pattern_storage_slots.length; ++s) {
            if (this.inventory.func_70301_a(this.pattern_storage_slots[s]).func_190926_b()) continue;
            storageStack = this.inventory.func_70301_a(this.pattern_storage_slots[s]);
            storage = (IMatterPatternStorage)this.inventory.func_70301_a(this.pattern_storage_slots[s]).func_77973_b();
            for (i = 0; i < storage.getCapacity(storageStack); ++i) {
                pattern = storage.getPatternAt(storageStack, i);
                if (pattern != null) continue;
                if (!simulate) {
                    storage.setItemPatternAt(storageStack, i, new ItemPattern(itemStack, amount));
                    if (this.getNetwork() != null) {
                        this.getNetwork().post(new MatterDatabaseEvent.PatternChanged(this, s, i));
                    }
                    this.forceSync();
                }
                if (info != null) {
                    info.append(String.format("%s added to Pattern Storage. Progress is now at %s", TextFormatting.GREEN + itemStack.func_82833_r(), amount + "%"));
                }
                return true;
            }
        }
        if (info != null) {
            info.append(String.format("%sNo space available for '%s' !", TextFormatting.RED, itemStack.func_82833_r()));
        }
        return false;
    }

    @Override
    public ItemPattern getPattern(ItemStack item) {
        for (int slotId : this.pattern_storage_slots) {
            ItemPattern hasItem;
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId)) || (hasItem = MatterDatabaseHelper.getPatternFromStorage(this.inventory.func_70301_a(slotId), item)) == null) continue;
            return hasItem;
        }
        return null;
    }

    @Override
    public ItemPattern getPattern(ItemPattern item) {
        for (int slotId : this.pattern_storage_slots) {
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId))) continue;
            IMatterPatternStorage storage = (IMatterPatternStorage)this.inventory.func_70301_a(slotId).func_77973_b();
            ItemStack storageStack = this.inventory.func_70301_a(slotId);
            for (int i = 0; i < storage.getCapacity(storageStack); ++i) {
                ItemPattern pattern = storage.getPatternAt(storageStack, i);
                if (pattern == null || !pattern.equals(item)) continue;
                return pattern;
            }
        }
        return null;
    }

    @Override
    public ItemStack[] getPatternStorageList() {
        ItemStack[] patternsDrives = new ItemStack[this.pattern_storage_slots.length];
        for (int i = 0; i < this.pattern_storage_slots.length; ++i) {
            patternsDrives[i] = this.func_70301_a(this.pattern_storage_slots[i]);
        }
        return patternsDrives;
    }

    @Override
    public void onPatternStorageChange(int storageId) {
        if (this.getNetwork() != null) {
            this.getNetwork().post(new MatterDatabaseEvent.PatternStorageChanged(this, storageId));
        }
    }

    @Override
    public ItemStack getPatternStorage(int slot) {
        ItemStack storageStack = this.inventory.func_70301_a(this.pattern_storage_slots[slot]);
        if (!storageStack.func_190926_b() && storageStack.func_77973_b() instanceof IMatterPatternStorage) {
            return storageStack;
        }
        return null;
    }

    @Override
    public int getPatternStorageCount() {
        return this.pattern_storage_slots.length;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{this.input_slot};
        }
        return this.pattern_storage_slots;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return true;
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        return side == blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        return this.networkComponent.establishConnectionFromSide(blockState, side);
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
        this.networkComponent.breakConnection(blockState, side);
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.networkComponent.getNetwork();
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.networkComponent.setNetwork(network);
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.networkComponent.canConnectToNetworkNode(blockState, toNode, direction);
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public MatterNetworkComponentClient getMatterNetworkComponent() {
        return this.networkComponent;
    }

    @Override
    public MatterNetworkTaskQueue getTaskQueue(int queueID) {
        return this.taskQueueComponent.getTaskQueue();
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }
}

