/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.fusionReactorController;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.blocks.BlockFusionReactorController;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.fusionReactorController.components.ComponentComputers;
import matteroverdrive.multiblock.IMultiBlockTile;
import matteroverdrive.multiblock.MultiBlockTileStructureMachine;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.tile.TileEntityFusionReactorPart;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineFusionReactorController
extends MOTileEntityMachineMatter {
    public static final int[] positions = new int[]{0, 5, 1, 0, 2, 0, 3, 1, 4, 2, 5, 3, 5, 4, 5, 5, 5, 6, 5, 7, 4, 8, 3, 9, 2, 10, 1, 10, 0, 10, -1, 10, -2, 10, -3, 9, -4, 8, -5, 7, -5, 6, -5, 5, -5, 4, -5, 3, -4, 2, -3, 1, -2, 0, -1, 0};
    public static final int[] blocks = new int[]{255, 2, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2};
    public static final int positionsCount = positions.length / 2;
    public static int STRUCTURE_CHECK_DELAY = 40;
    public static int MAX_GRAVITATIONAL_ANOMALY_DISTANCE = 3;
    public static int ENERGY_STORAGE = 100000000;
    public static int MATTER_STORAGE = 2048;
    public static int ENERGY_PER_TICK = 2048;
    public static double MATTER_DRAIN_PER_TICK = 0.0125;
    private final TimeTracker structureCheckTimer;
    private final MultiBlockTileStructureMachine multiBlock;
    private boolean validStructure = false;
    private MonitorInfo monitorInfo = MonitorInfo.INVALID_STRUCTURE;
    private float energyEfficiency;
    private int energyPerTick;
    private BlockPos anomalyPosition;
    private float matterPerTick;
    private float matterDrain;
    private ComponentComputers componentComputers;
    private long worldTickLast = 0L;

    public TileEntityMachineFusionReactorController() {
        super(4);
        this.structureCheckTimer = new TimeTracker();
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxExtract(ENERGY_STORAGE);
        this.energyStorage.setMaxReceive(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxExtract(0);
        this.matterStorage.setMaxReceive(MATTER_STORAGE);
        this.multiBlock = new MultiBlockTileStructureMachine(this);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74757_a("ValidStructure", this.validStructure);
            nbt.func_74768_a("MonitorInfo", this.monitorInfo.getMeta());
            nbt.func_74776_a("EnergyEfficiency", this.energyEfficiency);
            nbt.func_74776_a("MatterPerTick", this.matterPerTick);
            nbt.func_74768_a("EnergyPerTick", this.energyPerTick);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.validStructure = nbt.func_74767_n("ValidStructure");
            this.monitorInfo = MonitorInfo.fromMeta(nbt.func_74762_e("MonitorInfo"));
            this.energyEfficiency = nbt.func_74760_g("EnergyEfficiency");
            this.matterPerTick = nbt.func_74760_g("MatterPerTick");
            this.energyPerTick = nbt.func_74762_e("EnergyPerTick");
        }
    }

    @Override
    public void func_73660_a() {
        if (this.worldTickLast != this.func_145831_w().func_82737_E()) {
            this.worldTickLast = this.func_145831_w().func_82737_E();
            super.func_73660_a();
            if (!this.field_145850_b.field_72995_K) {
                this.manageStructure();
                this.manageEnergyGeneration();
                this.manageEnergyExtract();
            }
        }
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentComputers = new ComponentComputers(this);
        this.addComponent(this.componentComputers);
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.isValidStructure() && this.isGeneratingPower();
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    public Vec3d getPosition(int i, EnumFacing facing) {
        if (i < positionsCount) {
            EnumFacing back = facing.func_176734_d();
            Vec3d pos = new Vec3d((double)positions[i * 2], 0.0, (double)positions[i * 2 + 1]);
            if (back == EnumFacing.NORTH) {
                pos = pos.func_178785_b((float)Math.PI);
            } else if (back == EnumFacing.WEST) {
                pos = pos.func_178785_b(4.712389f);
            } else if (back == EnumFacing.EAST) {
                pos = pos.func_178789_a(1.5707964f);
            } else if (back == EnumFacing.UP) {
                pos = pos.func_178789_a(1.5707964f);
            } else if (back == EnumFacing.DOWN) {
                pos = pos.func_178789_a(4.712389f);
            }
            return pos;
        }
        return null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.multiBlock.invalidate();
    }

    public void manageStructure() {
        if (this.structureCheckTimer.hasDelayPassed(this.field_145850_b, STRUCTURE_CHECK_DELAY)) {
            this.multiBlock.update();
            EnumFacing side = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
            boolean validStructure = true;
            MonitorInfo info = this.monitorInfo;
            float energyEfficiency = this.energyEfficiency;
            float matterPerTick = this.matterPerTick;
            for (int i = 0; i < positionsCount; ++i) {
                Vec3d offset = this.getPosition(i, side);
                BlockPos position = new BlockPos(this.func_174877_v().func_177958_n() + (int)Math.round(offset.field_72450_a), this.func_174877_v().func_177956_o() + (int)Math.round(offset.field_72448_b), this.func_174877_v().func_177952_p() + (int)Math.round(offset.field_72449_c));
                if (blocks[i] == 255) {
                    int anomalyDistance;
                    BlockPos anomalyOffset = this.checkForGravitationalAnomaly(position, MOBlockHelper.getAboveSide(side));
                    if (anomalyOffset != null) {
                        anomalyDistance = (int)Math.sqrt(anomalyOffset.func_177958_n() * anomalyOffset.func_177956_o() + anomalyOffset.func_177956_o() * anomalyOffset.func_177956_o() + anomalyOffset.func_177952_p() * anomalyOffset.func_177952_p());
                        if (anomalyDistance > MAX_GRAVITATIONAL_ANOMALY_DISTANCE) {
                            validStructure = false;
                            info = MonitorInfo.ANOMALY_TOO_FAR;
                            break;
                        }
                    } else {
                        validStructure = false;
                        info = MonitorInfo.NO_ANOMALY;
                        this.anomalyPosition = null;
                        break;
                    }
                    this.anomalyPosition = anomalyOffset.func_177963_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                    energyEfficiency = 1.0f - (float)anomalyDistance / (float)(MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1);
                    this.energyPerTick = (int)Math.round((double)((float)ENERGY_PER_TICK * this.getEnergyEfficiency()) * this.getGravitationalAnomalyEnergyMultiply());
                    double energyMultiply = this.getGravitationalAnomalyEnergyMultiply();
                    matterPerTick = (float)(MATTER_DRAIN_PER_TICK * energyMultiply);
                    continue;
                }
                Block block = this.field_145850_b.func_180495_p(position).func_177230_c();
                TileEntity tileEntity = this.field_145850_b.func_175625_s(position);
                if (block == Blocks.field_150350_a) {
                    validStructure = false;
                    info = MonitorInfo.INVALID_STRUCTURE;
                    break;
                }
                if (block == MatterOverdrive.BLOCKS.machine_hull) {
                    if (blocks[i] == 1) {
                        validStructure = false;
                        info = MonitorInfo.NEED_COILS;
                        break;
                    }
                } else if (block == MatterOverdrive.BLOCKS.fusion_reactor_coil || tileEntity instanceof IMultiBlockTile) {
                    if (blocks[i] == 0) {
                        validStructure = false;
                        info = MonitorInfo.INVALID_MATERIALS;
                        break;
                    }
                } else if (block == MatterOverdrive.BLOCKS.decomposer) {
                    if (blocks[i] != 2) {
                        validStructure = false;
                        info = MonitorInfo.INVALID_MATERIALS;
                        break;
                    }
                } else {
                    validStructure = false;
                    info = MonitorInfo.INVALID_MATERIALS;
                    break;
                }
                if (!(tileEntity instanceof IMultiBlockTile)) continue;
                this.multiBlock.addMultiBlockTile((IMultiBlockTile)tileEntity);
            }
            if (validStructure) {
                info = MonitorInfo.OK;
            } else {
                energyEfficiency = 0.0f;
            }
            if (this.validStructure != validStructure || !this.monitorInfo.equals((Object)info) || this.energyEfficiency != energyEfficiency || this.matterPerTick != matterPerTick) {
                this.validStructure = validStructure;
                this.monitorInfo = info;
                this.energyEfficiency = energyEfficiency;
                this.matterPerTick = matterPerTick;
                this.forceSync();
            }
        }
    }

    private void manageEnergyGeneration() {
        int energyPerTick;
        int energyRecived;
        if (this.isActive() && (energyRecived = this.energyStorage.modifyEnergyStored(energyPerTick = this.getEnergyPerTick())) != 0) {
            this.matterDrain += this.getMatterDrainPerTick() * ((float)energyRecived / (float)energyPerTick);
            if (MathHelper.func_76141_d((float)this.matterDrain) >= 1) {
                this.matterStorage.modifyMatterStored(-MathHelper.func_76141_d((float)this.matterDrain));
                this.matterDrain -= (float)MathHelper.func_76141_d((float)this.matterDrain);
            }
            this.UpdateClientPower();
        }
    }

    private void manageEnergyExtract() {
        if (this.energyStorage.getEnergyStored() > 0) {
            for (IMultiBlockTile tile : this.multiBlock.getTiles()) {
                if (!(tile instanceof TileEntityFusionReactorPart)) continue;
                this.manageExtractFrom((TileEntityFusionReactorPart)tile);
            }
        }
        this.manageExtractFrom(this);
    }

    private void manageExtractFrom(MOTileEntityMachineEnergy source) {
        int startDir = random.nextInt(6);
        for (int i = 0; i < 6; ++i) {
            int energy = Math.min(this.energyStorage.getEnergyStored(), ENERGY_STORAGE);
            EnumFacing dir = EnumFacing.field_82609_l[(i + startDir) % 6];
            TileEntity entity = this.field_145850_b.func_175625_s(source.func_174877_v().func_177972_a(dir));
            if (entity == null || !entity.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) continue;
            this.energyStorage.modifyEnergyStored(-((IEnergyStorage)entity.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).receiveEnergy(energy, false));
        }
    }

    @Override
    public boolean isCharging() {
        return !this.inventory.func_70301_a(this.energySlotID).func_190926_b() && MOEnergyHelper.isEnergyContainerItem(this.inventory.func_70301_a(this.energySlotID));
    }

    @Override
    protected void manageCharging() {
        if (this.isCharging() && !this.field_145850_b.field_72995_K) {
            int maxExtracted = Math.min((int)this.energyStorage.getOutputRate(), this.energyStorage.getEnergyStored());
            int extracted = MOEnergyHelper.insertEnergyIntoContainer(this.inventory.func_70301_a(this.energySlotID), maxExtracted, false);
            this.energyStorage.modifyEnergyStored(extracted);
        }
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    public double getGravitationalAnomalyEnergyMultiply() {
        TileEntity entity;
        if (this.anomalyPosition != null && (entity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)this.anomalyPosition))) instanceof TileEntityGravitationalAnomaly) {
            return ((TileEntityGravitationalAnomaly)entity).getRealMassUnsuppressed();
        }
        return 0.0;
    }

    public float getMatterDrainPerTick() {
        return this.matterPerTick;
    }

    public boolean isGeneratingPower() {
        return this.getEnergyEfficiency() > 0.0f && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored() && (float)this.matterStorage.getMatterStored() > this.getMatterDrainPerTick();
    }

    public float getEnergyEfficiency() {
        return this.energyEfficiency;
    }

    private BlockPos checkForGravitationalAnomaly(BlockPos position, EnumFacing up) {
        for (int i = -MAX_GRAVITATIONAL_ANOMALY_DISTANCE; i < MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1; ++i) {
            Block block = this.field_145850_b.func_180495_p(position.func_177967_a(up, i)).func_177230_c();
            if (block == null || block != MatterOverdrive.BLOCKS.gravitational_anomaly) continue;
            return new BlockPos(0, 0, 0).func_177967_a(up, i);
        }
        return null;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockFusionReactorController)) {
            return Block.field_185505_j.func_186670_a(this.func_174877_v());
        }
        EnumFacing backSide = ((EnumFacing)state.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)).func_176734_d();
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + backSide.func_176730_m().func_177958_n() * 10), (double)(this.func_174877_v().func_177956_o() + backSide.func_176730_m().func_177956_o() * 10), (double)(this.func_174877_v().func_177952_p() + backSide.func_176730_m().func_177952_p() * 10));
    }

    public boolean isValidStructure() {
        return this.validStructure;
    }

    public MonitorInfo getMonitorInfo() {
        return this.monitorInfo;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage || type == UpgradeTypes.Range || type == UpgradeTypes.Speed;
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return super.getCapability(capability, facing);
    }

    public static enum MonitorInfo implements IStringSerializable
    {
        INVALID_STRUCTURE,
        NEED_COILS,
        INVALID_MATERIALS,
        NO_ANOMALY,
        ANOMALY_TOO_FAR,
        OK;

        public static MonitorInfo[] VALUES;

        public static MonitorInfo fromMeta(int meta) {
            return VALUES[MathHelper.func_76125_a((int)meta, (int)0, (int)VALUES.length)];
        }

        public int getMeta() {
            return this.ordinal();
        }

        @SideOnly(value=Side.CLIENT)
        public String localize() {
            return I18n.func_135052_a((String)("fusion_reactor.info." + this.func_176610_l()), (Object[])new Object[0]);
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = MonitorInfo.values();
        }
    }
}

