/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon.module;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.api.weapon.IWeaponStat;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class WeaponModuleBase
extends MOBaseItem
implements IWeaponModule {
    private Map<Integer, Map<IWeaponStat, Float>> metaStatMap = new HashMap<Integer, Map<IWeaponStat, Float>>();
    private int slot = -1;

    public WeaponModuleBase(String name) {
        super(name);
        this.func_77637_a(MatterOverdrive.TAB_OVERDRIVE_MODULES);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public void applySlot(int slot) {
        this.slot = slot;
    }

    public void applyWeaponStat(int meta, IWeaponStat stat, float value) {
        if (!this.metaStatMap.containsKey(meta)) {
            this.metaStatMap.put(meta, new HashMap());
        }
        Map<IWeaponStat, Float> statMap = this.metaStatMap.get(meta);
        statMap.put(stat, Float.valueOf(value));
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        super.addDetails(itemstack, player, worldIn, infos);
        Map<IWeaponStat, Float> statMap = this.metaStatMap.get(itemstack.func_77960_j());
        if (statMap != null && !statMap.isEmpty()) {
            statMap.forEach((stat, value) -> infos.add(MOStringHelper.weaponStatToInfo(stat, value.floatValue())));
        }
        infos.add(MOStringHelper.translateToLocal("moduleslot." + this.getSlot(itemstack) + ".name", new Object[0]));
    }

    @Override
    public float modifyWeaponStat(IWeaponStat stat, ItemStack module, ItemStack weapon, float originalStat) {
        Map<IWeaponStat, Float> statMap = this.metaStatMap.get(module.func_77960_j());
        if (statMap == null || statMap.isEmpty()) {
            return originalStat;
        }
        return originalStat * statMap.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public int getSlot(ItemStack module) {
        return this.slot;
    }
}

