/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransportFlashDrive
extends MOBaseItem {
    public TransportFlashDrive(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        super.addDetails(itemstack, player, worldIn, infos);
        if (this.hasTarget(itemstack)) {
            BlockPos target = this.getTarget(itemstack);
            IBlockState state = player.field_70170_p.func_180495_p(target);
            Block block = state.func_177230_c();
            infos.add(TextFormatting.YELLOW + String.format("[%s] %s", target.toString(), state.func_185904_a() != Material.field_151579_a ? block.func_149732_F() : "Unknown"));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151579_a) {
            this.setTarget(stack, pos);
            return EnumActionResult.SUCCESS;
        }
        this.removeTarget(stack);
        return EnumActionResult.FAIL;
    }

    public void setTarget(ItemStack itemStack, BlockPos pos) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74772_a("target", pos.func_177986_g());
    }

    public void removeTarget(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77982_d(null);
        }
    }

    public BlockPos getTarget(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return BlockPos.func_177969_a((long)itemStack.func_77978_p().func_74763_f("target"));
        }
        return null;
    }

    public boolean hasTarget(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("taget", 4);
    }
}

