/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PatternDrive
extends MOBaseItem
implements IMatterPatternStorage {
    final int capacity;

    public PatternDrive(String name, int capacity) {
        super(name);
        this.capacity = capacity;
        this.func_77625_d(1);
    }

    public int getDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150296_c().size() > 0) {
            if (stack.func_77978_p().func_150296_c().size() < this.getCapacity(stack)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        if (itemstack.func_77942_o()) {
            for (int i = 0; i < this.getCapacity(itemstack); ++i) {
                String displayName;
                ItemPattern pattern = this.getPatternAt(itemstack, i);
                if (pattern == null) continue;
                ItemStack stack = pattern.toItemStack(false);
                try {
                    displayName = stack.func_82833_r();
                }
                catch (Exception e) {
                    displayName = "Unknown";
                }
                if (MatterHelper.getMatterAmountFromItem(stack) > 0) {
                    infos.add(MatterDatabaseHelper.getPatternInfoColor(pattern.getProgress()) + displayName + " [" + pattern.getProgress() + "%]");
                    continue;
                }
                infos.add(TextFormatting.RED + "[Invalid] " + MatterDatabaseHelper.getPatternInfoColor(pattern.getProgress()) + displayName + " [" + pattern.getProgress() + "%]");
            }
        }
    }

    @Override
    public void InitTagCompount(ItemStack stack) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74777_a("Capacity", (short)this.capacity);
        NBTTagList itemList = new NBTTagList();
        tagCompound.func_74782_a("items", (NBTBase)itemList);
        stack.func_77982_d(tagCompound);
    }

    @Override
    public ItemPattern getPatternAt(ItemStack storage, int slot) {
        if (storage.func_77978_p() != null && slot < this.getCapacity(storage) && storage.func_77978_p().func_74764_b("p" + slot)) {
            ItemPattern pattern = new ItemPattern(storage.func_77978_p().func_74775_l("p" + slot));
            return pattern;
        }
        return null;
    }

    @Override
    public void setItemPatternAt(ItemStack storage, int slot, ItemPattern itemPattern) {
        if (storage.func_77978_p() == null) {
            storage.func_77982_d(new NBTTagCompound());
        }
        if (itemPattern != null) {
            NBTTagCompound patternTag = new NBTTagCompound();
            itemPattern.writeToNBT(patternTag);
            storage.func_77978_p().func_74782_a("p" + slot, (NBTBase)patternTag);
        } else {
            storage.func_77978_p().func_82580_o("p" + slot);
        }
    }

    @Override
    public boolean increasePatternProgress(ItemStack itemStack, int slot, int amount) {
        return false;
    }

    @Override
    public int getCapacity(ItemStack item) {
        this.TagCompountCheck(item);
        return item.func_77978_p().func_74765_d("Capacity");
    }

    public void clearStorage(ItemStack itemStack) {
        if (MatterHelper.isMatterPatternStorage(itemStack)) {
            itemStack.func_77982_d(null);
        }
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.clearStorage(itemStack);
        }
        return itemStack;
    }
}

