/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.Quest;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.gui.GuiQuestPreview;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Contract
extends MOBaseItem {
    public Contract(String name) {
        super(name);
        this.func_77637_a(MatterOverdrive.TAB_OVERDRIVE_CONTRACTS);
    }

    public QuestStack getQuest(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return QuestStack.loadFromNBT(itemStack.func_77978_p());
        }
        return null;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        QuestStack questStack = QuestStack.loadFromNBT(itemstack.func_77978_p());
        if (questStack != null) {
            for (int i = 0; i < questStack.getObjectivesCount(player); ++i) {
                infos.add(MatterOverdrive.QUEST_FACTORY.getFormattedQuestObjective(player, questStack, i));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            MatterOverdrive.QUESTS.getAllQuestName().forEach(name -> {
                ItemStack stack = new ItemStack((Item)this);
                IQuest quest = MatterOverdrive.QUESTS.getQuestByName((String)name);
                QuestStack questStack = MatterOverdrive.QUEST_FACTORY.generateQuestStack(field_77697_d, quest);
                NBTTagCompound questTag = new NBTTagCompound();
                questStack.writeToNBT(questTag);
                stack.func_77982_d(questTag);
                items.add((Object)stack);
            });
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            QuestStack questStack = QuestStack.loadFromNBT(itemStack.func_77978_p());
            return questStack.getTitle();
        }
        return super.func_77653_i(itemStack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStackIn = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            this.openGui(itemStackIn);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        QuestStack questStack = this.getQuest(itemStackIn);
        if (questStack == null) {
            Quest quest = ((WeightedRandomQuest)WeightedRandom.func_76271_a((Random)field_77697_d, MatterOverdriveQuests.contractGeneration)).getQuest();
            questStack = MatterOverdrive.QUEST_FACTORY.generateQuestStack(field_77697_d, quest);
            NBTTagCompound questTag = new NBTTagCompound();
            questStack.writeToNBT(questTag);
            itemStackIn.func_77982_d(questTag);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(ItemStack stack) {
        QuestStack questStack = this.getQuest(stack);
        if (questStack != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiQuestPreview(this.getQuest(stack)));
        }
    }
}

