/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.api.quest.IQuestLogic;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.GenericMultiQuest;
import matteroverdrive.data.quest.GenericQuest;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.RandomQuestText;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.data.quest.logic.QuestLogicBecomeAndroid;
import matteroverdrive.data.quest.logic.QuestLogicBlockInteract;
import matteroverdrive.data.quest.logic.QuestLogicCocktailOfAscension;
import matteroverdrive.data.quest.logic.QuestLogicConversation;
import matteroverdrive.data.quest.logic.QuestLogicCraft;
import matteroverdrive.data.quest.logic.QuestLogicItemInteract;
import matteroverdrive.data.quest.logic.QuestLogicMine;
import matteroverdrive.data.quest.logic.QuestLogicPlaceBlock;
import matteroverdrive.data.quest.logic.QuestLogicScanBlock;
import matteroverdrive.data.quest.logic.QuestLogicSingleEvent;
import matteroverdrive.data.quest.rewards.ItemStackReward;
import matteroverdrive.data.quest.rewards.QuestStackReward;
import matteroverdrive.entity.android_player.AndroidAttributes;
import matteroverdrive.handler.quest.Quests;
import matteroverdrive.init.MatterOverdriveDialogs;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class MatterOverdriveQuests {
    public static final List<WeightedRandom.Item> contractGeneration = new ArrayList<WeightedRandom.Item>();
    public static RandomQuestText killAndroids;
    public static GenericQuest cocktailOfAscension;
    public static GenericQuest sacrifice;
    public static GenericQuest departmentOfAgriculture;
    public static GenericQuest weaponsOfWar;
    public static GenericQuest oneTrueLove;
    public static GenericQuest toThePowerOf;
    public static GenericQuest punyHumans;
    public static GenericQuest is_it_really_me;
    public static GenericQuest beast_belly;
    public static GenericQuest crashLanding;
    public static GenericQuest weMustKnow;
    public static GenericMultiQuest gmo;
    public static GenericMultiQuest trade_route;

    public static void init() {
        MatterOverdriveQuests.initMatterOverdriveQuests();
        MatterOverdriveQuests.initModdedQuests();
    }

    private static void initMatterOverdriveQuests() {
        cocktailOfAscension = (GenericQuest)new GenericQuest(new QuestLogicCocktailOfAscension(), "cocktail_of_ascension", 512).addQuestRewards(new ItemStackReward((Item)MatterOverdrive.ITEMS.androidPill, 1, 0), new ItemStackReward((Item)MatterOverdrive.ITEMS.androidPill, 1, 1), new ItemStackReward((Item)MatterOverdrive.ITEMS.androidPill, 1, 2));
        oneTrueLove = (GenericQuest)new GenericQuest(new QuestLogicMine(Blocks.field_150482_ag.func_176223_P(), 1, 1, 180).setAutoComplete(true), "one_true_love", 0).addQuestRewards(new ItemStackReward(Items.field_151166_bC, 6));
        punyHumans = (GenericQuest)new GenericQuest(new QuestLogicBecomeAndroid(), "puny_humans", 256).addQuestRewards(new ItemStackReward(MatterOverdrive.ITEMS.battery), new ItemStackReward((Item)MatterOverdrive.ITEMS.androidPill, 1, 1), new ItemStackReward((Item)MatterOverdrive.ITEMS.androidPill, 5, 2));
        is_it_really_me = (GenericQuest)new GenericQuest(new QuestLogicSingleEvent(MOEventTransport.class).setAutoComplete(true), "is_it_really_me", 120).addQuestRewards(new ItemStackReward(MatterOverdrive.ITEMS.item_upgrade, 2, 4));
        beast_belly = (GenericQuest)new GenericQuest(new QuestLogicSingleEvent(MOEventGravitationalAnomalyConsume.class), "beast_belly", 210).addQuestRewards(new ItemStackReward(MatterOverdrive.BLOCKS.gravitational_stabilizer, 2));
        weMustKnow = (GenericQuest)new GenericQuest(new QuestLogicPlaceBlock(4, new QuestItem(new ItemStack((Block)MatterOverdrive.BLOCKS.decorative_coils).func_151001_c("Communication Relay")), 1, 1).setAutoComplete(true), "we_must_know", 120).addQuestRewards(new ItemStackReward(Items.field_151166_bC, 8));
        crashLanding = (GenericQuest)new GenericQuest(new QuestLogicCraft(new ItemStack((Item)MatterOverdrive.ITEMS.security_protocol), 0, 0, 0).setAutoComplete(true), "crash_landing", 60).addQuestRewards(new ItemStackReward(new ItemStack((Block)MatterOverdrive.BLOCKS.decorative_coils).func_151001_c("Communication Relay")), new QuestStackReward(new QuestStack(weMustKnow)).setCopyNBT("Pos"));
        gmo = (GenericMultiQuest)new GenericMultiQuest(new IQuestLogic[]{new QuestLogicScanBlock(new QuestBlock(Blocks.field_150459_bM.func_176223_P()), 12, 24, 10).setOnlyDestroyable(true), new QuestLogicScanBlock(new QuestBlock(Blocks.field_150469_bN.func_176223_P()), 12, 24, 10).setOnlyDestroyable(true)}, "gmo", 0).setAutoComplete(true).setSequential(true).addQuestRewards(new ItemStackReward(MatterOverdrive.ANDROID_PARTS_FACTORY.addAttributeToPart(MatterOverdrive.ANDROID_PARTS_FACTORY.addAttributeToPart(new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumSpine), new AttributeModifier(SharedMonsterAttributes.field_111267_a.func_111108_a(), 5.0, 0)), new AttributeModifier(AndroidAttributes.attributeGlitchTime.func_111108_a(), -1.0, 2)).func_151001_c("Hardened Tritanium Spine")));
        trade_route = new GenericMultiQuest(new IQuestLogic[]{new QuestLogicBlockInteract(null, true, false), new QuestLogicItemInteract(new QuestItem(new ItemStack((Item)MatterOverdrive.ITEMS.isolinear_circuit).func_151001_c("Trade Route Agreement")), true), new QuestLogicConversation("mo.mad_scientist", MatterOverdriveDialogs.tradeRouteQuest, MatterOverdriveDialogs.tradeRouteQuest)}, "trade_route", 180).setAutoComplete(true).setSequential(true);
    }

    private static void initModdedQuests() {
    }

    public static void register(Quests quests) {
        MatterOverdriveQuests.registerMatterOverdriveQuests(quests);
        MatterOverdriveQuests.registerModdedQuests(quests);
    }

    private static void registerMatterOverdriveQuests(Quests quests) {
        quests.registerQuest("cocktail_of_ascension", cocktailOfAscension);
        quests.registerQuest("one_true_love", oneTrueLove);
        quests.registerQuest("puny_humans", punyHumans);
        quests.registerQuest("is_it_really_me", is_it_really_me);
        quests.registerQuest("beast_belly", beast_belly);
        quests.registerQuest("crash_landing", crashLanding);
        quests.registerQuest("weMustKnow", weMustKnow);
        quests.registerQuest("gmo", gmo);
        quests.registerQuest("trade_route", trade_route);
        contractGeneration.add(new WeightedRandomQuest(oneTrueLove, 100));
        contractGeneration.add(new WeightedRandomQuest(is_it_really_me, 80));
        contractGeneration.add(new WeightedRandomQuest(beast_belly, 60));
    }

    private static void registerModdedQuests(Quests quests) {
    }
}

