/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.guide.GuideCategory;
import matteroverdrive.guide.GuideElementDetails;
import matteroverdrive.guide.GuideElementImage;
import matteroverdrive.guide.GuideElementPreview;
import matteroverdrive.guide.GuideElementRecipe;
import matteroverdrive.guide.GuideElementText;
import matteroverdrive.guide.GuideElementTitle;
import matteroverdrive.guide.GuideElementTooltip;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MOGuideEntryBlock;
import matteroverdrive.guide.MOGuideEntryItem;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.guide.infograms.InfogramCreates;
import matteroverdrive.guide.infograms.InfogramDepth;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MatterOverdriveGuides {
    public static GuideCategory androidCategory;
    public static GuideCategory weaponsCategory;
    public static GuideCategory generalCategory;

    public static void registerGuideElements(FMLInitializationEvent event) {
        MatterOverdriveGuide.registerGuideElementHandler("text", GuideElementText.class);
        MatterOverdriveGuide.registerGuideElementHandler("depth", InfogramDepth.class);
        MatterOverdriveGuide.registerGuideElementHandler("creates", InfogramCreates.class);
        MatterOverdriveGuide.registerGuideElementHandler("recipe", GuideElementRecipe.class);
        MatterOverdriveGuide.registerGuideElementHandler("title", GuideElementTitle.class);
        MatterOverdriveGuide.registerGuideElementHandler("image", GuideElementImage.class);
        MatterOverdriveGuide.registerGuideElementHandler("preview", GuideElementPreview.class);
        MatterOverdriveGuide.registerGuideElementHandler("details", GuideElementDetails.class);
        MatterOverdriveGuide.registerGuideElementHandler("tooltip", GuideElementTooltip.class);
    }

    public static void registerGuides(FMLPostInitializationEvent event) {
        generalCategory = new GuideCategory("general").setHoloIcon("home_icon");
        MatterOverdriveGuide.registerCategory(generalCategory);
        weaponsCategory = new GuideCategory("weapons").setHoloIcon("ammo");
        MatterOverdriveGuide.registerCategory(weaponsCategory);
        androidCategory = new GuideCategory("android").setHoloIcon("android_slot_arms");
        MatterOverdriveGuide.registerCategory(androidCategory);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.dilithium_ore).setGroup("resources"), 3, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.tritaniumOre).setGroup("resources"), 4, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.dilithium_crystal).setGroup("resources"), 3, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.tritanium_ingot).setGroup("resources"), 4, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.replicator).setGroup("machines"), 0, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.decomposer).setGroup("machines"), 1, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.recycler).setGroup("machines"), 0, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.matter_analyzer).setGroup("machines"), 1, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.pattern_storage).setGroup("machines"), 0, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.pattern_monitor).setGroup("machines"), 1, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.transporter).setGroup("machines"), 0, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.holoSign).setGroup("machines"), 1, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.inscriber).setGroup("machines"), 0, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.contractMarket).setGroup("machines"), 1, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("fusion_reactor", new ItemStack[0]).setStackIcons(new ItemStack((Block)MatterOverdrive.BLOCKS.fusion_reactor_controller), new ItemStack((Block)MatterOverdrive.BLOCKS.fusion_reactor_coil), new ItemStack((Block)MatterOverdrive.BLOCKS.fusionReactorIO)).setGroup("power"), 3, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.gravitational_anomaly).setGroup("power"), 4, 3);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.pylon).setGroup("power"), 3, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.solar_panel).setGroup("power"), 4, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("batteries", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdrive.ITEMS.battery), new ItemStack((Item)MatterOverdrive.ITEMS.hc_battery), new ItemStack((Item)MatterOverdrive.ITEMS.creative_battery)).setGroup("power"), 3, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_transport", new ItemStack[0]).setStackIcons(MatterOverdrive.BLOCKS.heavy_matter_pipe).setGroup("matter"), 6, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_fail", new ItemStack[0]).setStackIcons(MatterOverdrive.ITEMS.matter_dust).setGroup("matter"), 7, 0);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("matter_plasma", MatterOverdrive.ITEMS.matterContainer.getFullStack()).setGroup("matter"), 6, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.matter_scanner).setGroup("matter"), 7, 1);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.pattern_drive).setGroup("matter"), 6, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.portableDecomposer).setGroup("matter"), 7, 2);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.network_pipe).setGroup("matter_network"), 6, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.network_switch).setGroup("matter_network"), 7, 4);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.networkFlashDrive).setGroup("matter_network"), 6, 5);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.network_router).setGroup("matter_network"), 7, 5);
        int itemsY = 7;
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem((Item)MatterOverdrive.ITEMS.spacetime_equalizer).setGroup("items"), 0, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.security_protocol).setGroup("items"), 1, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("upgrades", new ItemStack[0]).setStackIcons(MatterOverdrive.ITEMS.item_upgrade).setGroup("items"), 2, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("drinks", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdrive.ITEMS.romulan_ale), new ItemStack((Item)MatterOverdrive.ITEMS.earl_gray_tea)).setGroup("items"), 3, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntry("food", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdrive.ITEMS.emergency_ration)).setGroup("items"), 4, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.wrench).setGroup("items"), 0, ++itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.transportFlashDrive).setGroup("items"), 1, itemsY);
        MatterOverdriveGuides.addEntry(generalCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.contract).setGroup("items"), 2, itemsY);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.phaser).setGroup("weapons"), 4, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.phaserRifle).setGroup("weapons"), 5, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.omniTool).setGroup("weapons"), 6, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.plasmaShotgun).setGroup("weapons"), 4, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.ionSniper).setGroup("weapons"), 5, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("tritanium_tools", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumAxe), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumSword), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumHoe), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumPickaxe)).setGroup("weapons"), 6, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.energyPack).setGroup("parts"), 1, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("weapon.modules.barrels", new ItemStack[0]).setStackIcons(MatterOverdrive.ITEMS.weapon_module_barrel).setGroup("parts"), 2, 0);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("weapon.modules.colors", new ItemStack[0]).setStackIcons(MatterOverdrive.ITEMS.weapon_module_color).setGroup("parts"), 1, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.sniperScope).setGroup("parts"), 2, 1);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntry("tritanium_armor", new ItemStack[0]).setStackIcons(new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumChestplate), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumLeggings), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumBoots), new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumHelmet)).setGroup("armor"), 1, 3);
        MatterOverdriveGuides.addEntry(weaponsCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.weapon_station).setGroup("machines"), 4, 3);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntry("android.pills", new ItemStack[0]).setStackIcons((Item)MatterOverdrive.ITEMS.androidPill).setGroup("items"), 5, 1);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntry("android.parts", new ItemStack[0]).setStackIcons(MatterOverdrive.ITEMS.androidParts).setGroup("items"), 5, 2);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntryItem(MatterOverdrive.ITEMS.tritaniumSpine).setGroup("items"), 5, 3);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.androidStation).setGroup("machines"), 2, 2);
        MatterOverdriveGuides.addEntry(androidCategory, new MOGuideEntryBlock(MatterOverdrive.BLOCKS.chargingStation).setGroup("machines"), 3, 2);
    }

    private static void addEntry(GuideCategory category, MOGuideEntry entry, int x, int y) {
        int paddingTop = 16;
        int paddingLeft = 18;
        category.addEntry(entry);
        entry.setGuiPos(paddingLeft + x * 28, paddingTop + y * 28);
        entry.setId(MatterOverdriveGuide.getNextFreeID());
        MatterOverdriveGuide.registerEntry(entry);
    }
}

