/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.imc;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.matter.DamageAwareStackHandler;
import matteroverdrive.data.matter.ItemHandler;
import matteroverdrive.data.matter.OreHandler;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.init.MatterOverdriveRecipes;
import matteroverdrive.util.MOLog;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MOIMCHandler {
    public static void imcCallback(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(MOIMCHandler::handleMessage);
    }

    public static void handleMessage(FMLInterModComms.IMCMessage msg) {
        switch (msg.key) {
            case "registry:blacklist:add": {
                MOIMCHandler.handleItemBlacklistRegistration(msg);
                break;
            }
            case "registry:blacklist:mod:add": {
                MatterOverdrive.MATTER_REGISTRY.addModToBlacklist(msg.getStringValue());
                break;
            }
            case "registry:inscriber:recipe:add": {
                MOIMCHandler.handleInscriberRecipeRegistration(msg);
                break;
            }
            case "registry:matter:add": {
                MOIMCHandler.handleMatterRegistration(msg);
            }
        }
    }

    private static void handleMatterRegistration(FMLInterModComms.IMCMessage msg) {
        if (!msg.isNBTMessage()) {
            MOLog.warn("Invalid message type for Matter Registration. Message needs to be of type NBT", new Object[0]);
            return;
        }
        try {
            NBTTagCompound data = msg.getNBTValue();
            if (MOIMCHandler.containsAllTags(data, "Matter")) {
                int matter = data.func_74762_e("Matter");
                boolean isFinalHandler = data.func_74767_n("FinalMatter");
                if (data.func_150297_b("Item", 10)) {
                    ItemStack itemStack = new ItemStack(data.func_74775_l("Item"));
                    if (data.func_74767_n("MetaAware")) {
                        MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new DamageAwareStackHandler(itemStack.func_77952_i(), matter, isFinalHandler));
                    } else {
                        MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new ItemHandler(matter, isFinalHandler));
                    }
                } else if (data.func_150297_b("Ore", 8)) {
                    String oreName = data.func_74779_i("Ore");
                    MatterOverdrive.MATTER_REGISTRY.registerOre(oreName, new OreHandler(matter, isFinalHandler));
                }
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to register an Item in the Matter Registry from: %s", msg.getSender());
        }
    }

    private static void handleItemBlacklistRegistration(FMLInterModComms.IMCMessage msg) {
        try {
            if (msg.isItemStackMessage()) {
                ItemStack itemStack = msg.getItemStackValue();
                if (itemStack != null) {
                    MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new DamageAwareStackHandler(itemStack.func_77952_i(), 0, true));
                }
            } else if (msg.isNBTMessage()) {
                NBTTagCompound data = msg.getNBTValue();
                ItemStack itemStack = new ItemStack(data.func_74775_l("Item"));
                if (data.func_150297_b("Item", 10)) {
                    if (data.func_74767_n("MetaAware")) {
                        MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new DamageAwareStackHandler(itemStack.func_77952_i(), 0, true));
                    } else {
                        MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new ItemHandler(0, true));
                    }
                } else if (data.func_150297_b("Ore", 8)) {
                    String oreName = data.func_74779_i("Ore");
                    MatterOverdrive.MATTER_REGISTRY.registerOre(oreName, new OreHandler(0, true));
                }
            } else {
                MOLog.warn("Invalid message type for Matter Blacklisting. Message needs to be of type NBT or ItemStack", new Object[0]);
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to blacklist an Item in the Matter Registry from: %s", msg.getSender());
        }
    }

    private static void handleInscriberRecipeRegistration(FMLInterModComms.IMCMessage msg) {
        if (!msg.isStringMessage()) {
            MOLog.error("Invalid message format for Inscriber Recipe registration. Message must be a String message", new Object[0]);
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(msg.getStringValue().getBytes()));
            NodeList nodes = document.getElementsByTagName("recipe");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                InscriberRecipe recipe = new InscriberRecipe();
                recipe.fromXML(e);
                MatterOverdriveRecipes.INSCRIBER.register(recipe);
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to register an Inscriber Recipe from: %s", msg.getSender());
        }
    }

    private static boolean containsAllTags(NBTTagCompound tagCompound, String ... tags) {
        for (String tag : tags) {
            if (tagCompound.func_74764_b(tag)) continue;
            return false;
        }
        return true;
    }
}

