/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.weapon;

import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonWeaponHandler {
    private static final PacketFirePlasmaShot.BiHandler firePlasmaShotHandler = new PacketFirePlasmaShot.BiHandler();
    private final Map<EntityPlayer, Long> weaponTimestamps = new HashMap<EntityPlayer, Long>();

    public void addTimestamp(EntityPlayer player, long timestamp) {
        this.weaponTimestamps.put(player, timestamp);
    }

    public boolean hasTimestamp(EntityPlayer player) {
        return this.weaponTimestamps.containsKey(player);
    }

    public long getTimestamp(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return this.weaponTimestamps.get(entityPlayer);
        }
        return 0L;
    }

    public void handlePlasmaShotFire(EntityPlayer entityPlayer, PacketFirePlasmaShot plasmaShot, long timeStamp) {
        int delay = (int)(timeStamp - this.getTimestamp(entityPlayer));
        firePlasmaShotHandler.handleServerShot(entityPlayer, plasmaShot, delay);
        MatterOverdrive.NETWORK.sendToAllAround((IMessage)plasmaShot, entityPlayer, (double)(plasmaShot.getShot().getRange() + 64));
    }

    @SubscribeEvent
    public void onEnergyWeaponEvent(MOEventEnergyWeapon eventEnergyWeapon) {
        AndroidPlayer androidPlayer;
        if (eventEnergyWeapon.getEntity() != null && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability(eventEnergyWeapon.getEntity())) != null) {
            androidPlayer.onWeaponEvent(eventEnergyWeapon);
        }
    }
}

