/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.weapon;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.CommonWeaponHandler;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.network.packet.bi.PacketWeaponTick;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientWeaponHandler
extends CommonWeaponHandler {
    private static final float RECOIL_RESET_SPEED = 0.03f;
    private static final float CAMERA_RECOIL_RESET_SPEED = 0.03f;
    public static float ZOOM_TIME;
    public static float RECOIL_TIME;
    public static float RECOIL_AMOUNT;
    public static float CAMERA_RECOIL_TIME;
    public static float CAMERA_RECOIL_AMOUNT;
    private final Map<IWeapon, Integer> shotTracker;
    private final IntHashMap<PlasmaBolt> plasmaBolts;
    private final Random cameraRecoilRandom = new Random();
    private float lastMouseSensitivity;
    private int nextShotID;
    private boolean hasChangedSensitivity = false;

    public ClientWeaponHandler() {
        this.shotTracker = new HashMap<IWeapon, Integer>();
        this.plasmaBolts = new IntHashMap();
    }

    public void registerWeapon(IWeapon weapon) {
        this.shotTracker.put(weapon, 0);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            for (IWeapon item : this.shotTracker.keySet()) {
                int oldTime = this.shotTracker.get(item);
                if (oldTime <= 0) continue;
                this.shotTracker.put(item, oldTime - 1);
            }
            this.manageWeaponView();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && event.phase.equals((Object)TickEvent.Phase.END)) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            ZOOM_TIME = entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null && entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon ? (((IWeapon)entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).isWeaponZoomed((EntityLivingBase)entityPlayer, entityPlayer.func_184586_b(EnumHand.MAIN_HAND)) ? Math.min(ZOOM_TIME + event.renderTickTime * 0.1f, 1.0f) : Math.max(ZOOM_TIME - event.renderTickTime * 0.1f, 0.0f)) : Math.max(ZOOM_TIME - event.renderTickTime * 0.2f, 0.0f);
            if (ZOOM_TIME == 0.0f) {
                if (this.hasChangedSensitivity) {
                    this.hasChangedSensitivity = false;
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity;
                } else {
                    this.lastMouseSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
                }
            } else if (ZOOM_TIME != 0.0f) {
                if (entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null && entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
                    this.hasChangedSensitivity = true;
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity * (1.0f - ZOOM_TIME * ((IWeapon)entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getZoomMultiply((EntityPlayer)entityPlayer, entityPlayer.func_184586_b(EnumHand.MAIN_HAND)));
                } else {
                    this.hasChangedSensitivity = true;
                    Minecraft.func_71410_x().field_71474_y.field_74341_c = this.lastMouseSensitivity;
                }
            }
            if (RECOIL_TIME > 0.0f) {
                RECOIL_TIME = Math.max(0.0f, RECOIL_TIME - 0.03f);
            }
            if (CAMERA_RECOIL_TIME > 0.0f) {
                CAMERA_RECOIL_TIME = Math.max(0.0f, CAMERA_RECOIL_TIME - 0.03f);
            }
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND) != null && Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
            event.setNewfov(event.getFov() - event.getFov() * ZOOM_TIME * ((IWeapon)Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getZoomMultiply((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND)));
        }
    }

    private void manageWeaponView() {
        for (Object playerObj : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)playerObj;
            ItemStack currentitem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (currentitem == null || !(currentitem.func_77973_b() instanceof IWeapon) || !((IWeapon)currentitem.func_77973_b()).isAlwaysEquipped(currentitem)) continue;
            if (player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                currentitem.func_77964_b(0);
                continue;
            }
            currentitem.func_77964_b(1);
            player.func_184598_c(EnumHand.MAIN_HAND);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendWeaponTickToServer(World world, PacketFirePlasmaShot firePlasmaShot) {
        MatterOverdrive.NETWORK.sendToServer(new PacketWeaponTick(world.func_72820_D(), firePlasmaShot));
    }

    public boolean shootDelayPassed(IWeapon item) {
        return this.shotTracker.get(item) <= 0;
    }

    public void addShootDelay(IWeapon item, ItemStack weaponStack) {
        if (this.shotTracker.containsKey(item)) {
            this.shotTracker.put(item, this.shotTracker.get(item) + item.getShootCooldown(weaponStack));
        }
    }

    public void addReloadDelay(IWeapon weapon, int delay) {
        if (this.shotTracker.containsKey(weapon)) {
            this.shotTracker.put(weapon, this.shotTracker.get(weapon) + delay);
        }
    }

    public void setRecoil(float amount, float time, float viewRecoilMultiply) {
        RECOIL_AMOUNT = amount;
        RECOIL_TIME = time;
        Minecraft.func_71410_x().field_71439_g.field_70125_A -= amount * viewRecoilMultiply;
    }

    public void setCameraRecoil(float amount, float time) {
        CAMERA_RECOIL_AMOUNT = amount * (float)(this.cameraRecoilRandom.nextBoolean() ? -1 : 1);
        CAMERA_RECOIL_TIME = time;
    }

    public float getEquippedWeaponAccuracyPercent(EntityPlayer entityPlayer) {
        if (entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null && entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
            return ((IWeapon)entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getAccuracy(entityPlayer.func_184586_b(EnumHand.MAIN_HAND), (EntityLivingBase)entityPlayer, ((IWeapon)entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).isWeaponZoomed((EntityLivingBase)entityPlayer, entityPlayer.func_184586_b(EnumHand.MAIN_HAND))) / ((IWeapon)entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxHeat(entityPlayer.func_184586_b(EnumHand.MAIN_HAND));
        }
        return 0.0f;
    }

    public void addPlasmaBolt(PlasmaBolt plasmaBolt) {
        this.plasmaBolts.func_76038_a(plasmaBolt.func_145782_y(), (Object)plasmaBolt);
    }

    public void removePlasmaBolt(PlasmaBolt plasmaBolt) {
        this.plasmaBolts.func_76049_d(plasmaBolt.func_145782_y());
    }

    public PlasmaBolt getPlasmaBolt(int id) {
        return (PlasmaBolt)this.plasmaBolts.func_76041_a(id);
    }

    public int getNextShotID() {
        return this.nextShotID++;
    }

    public WeaponShot getNextShot(ItemStack weaponStack, EnergyWeapon energyWeapon, EntityLivingBase shooter, boolean zoomed) {
        return new WeaponShot(this.getNextShotID(), energyWeapon.getWeaponScaledDamage(weaponStack, shooter), energyWeapon.getAccuracy(weaponStack, shooter, zoomed), WeaponHelper.getColor(weaponStack), energyWeapon.getRange(weaponStack));
    }
}

