/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.thread;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.matter.ItemStackHandlerCachable;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.init.MatterOverdriveRecipes;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class RegisterItemsFromRecipes
implements Runnable {
    private final File file;

    public RegisterItemsFromRecipes(File file) {
        this.file = file;
    }

    @Override
    public void run() {
        MatterOverdrive.PROXY.matterToast(true, 8000L);
        int passesCount = 10;
        for (int pass = 0; pass < passesCount; ++pass) {
            if (MatterOverdrive.MATTER_REGISTRY.CALCULATE_RECIPES) {
                CopyOnWriteArrayList recipes = new CopyOnWriteArrayList(ForgeRegistries.RECIPES.getValuesCollection());
                for (IRecipe recipe : recipes) {
                    if (recipe == null || recipe.func_77571_b().func_190926_b()) continue;
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        ItemStack itemStack = recipe.func_77571_b();
                        if (itemStack.func_77984_f() || itemStack.hasCapability(CapabilityEnergy.ENERGY, null)) continue;
                        if (!itemStack.func_190926_b() && !MatterOverdrive.MATTER_REGISTRY.blacklistedFromMod(itemStack)) {
                            this.debug("Calculating Recipe for: %s", recipe.func_77571_b());
                            int matter = MatterOverdrive.MATTER_REGISTRY.getMatter(itemStack);
                            if (matter > 0) continue;
                            matter = MatterOverdrive.MATTER_REGISTRY.getMatterFromRecipe(itemStack);
                            if (matter > 0) {
                                MatterOverdrive.MATTER_REGISTRY.register(itemStack.func_77973_b(), new ItemStackHandlerCachable(matter, itemStack.func_77952_i()));
                                continue;
                            }
                            this.debug("Could not calculate recipe for: %s. Matter from recipe is 0.", recipe.func_77571_b());
                            continue;
                        }
                        this.debug("% was blacklisted. Skipping matter calculation", recipe.func_77571_b());
                    }
                    catch (Exception e) {
                        if (!recipe.func_77571_b().func_190926_b()) {
                            this.debug("Recipe missing output", e, new Object[0]);
                            continue;
                        }
                        this.debug("There was a problem calculating matter from recipe", e, new Object[0]);
                    }
                }
            }
            if (MatterOverdrive.MATTER_REGISTRY.CALCULATE_FURNACE) {
                this.registerFromInscriber();
            }
            if (!MatterOverdrive.MATTER_REGISTRY.CALCULATE_INSCRIBER) continue;
            this.registerFromFurnace();
        }
        if (MatterOverdrive.MATTER_REGISTRY.CALCULATE_FURNACE || MatterOverdrive.MATTER_REGISTRY.CALCULATE_INSCRIBER || MatterOverdrive.MATTER_REGISTRY.CALCULATE_RECIPES) {
            long startTime = System.nanoTime();
            MOLog.info("Saving Registry to Disk", new Object[0]);
            try {
                MatterOverdrive.MATTER_REGISTRY.saveToFile(this.file);
                MOLog.info("Registry saved at: %s. Took %s Milliseconds.", this.file.getPath(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "Could not save registry to: %s", this.file.getPath());
            }
        }
        MatterOverdrive.MATTER_REGISTRY.hasComplitedRegistration = true;
        MatterOverdrive.MATTER_REGISTRATION_HANDLER.onRegistrationComplete();
        MatterOverdrive.PROXY.matterToast(false, 8000L);
    }

    private void registerFromInscriber() {
        for (InscriberRecipe recipe : MatterOverdriveRecipes.INSCRIBER.getRecipes()) {
            if (recipe.getMain().func_190926_b() || recipe.getOutput().func_190926_b()) continue;
            int keyMatter = MatterHelper.getMatterAmountFromItem(recipe.getMain()) * recipe.getMain().func_190916_E() / recipe.getOutput().func_190916_E();
            int secMatter = 0;
            if (!recipe.getSec().func_190926_b()) {
                secMatter = MatterHelper.getMatterAmountFromItem(recipe.getSec()) * recipe.getSec().func_190916_E() / recipe.getOutput().func_190916_E();
            }
            int valueMatter = MatterHelper.getMatterAmountFromItem(recipe.getOutput());
            if ((keyMatter += secMatter) <= 0 || valueMatter > 0) continue;
            MatterOverdrive.MATTER_REGISTRY.register(recipe.getOutput().func_77973_b(), new ItemStackHandlerCachable(keyMatter, recipe.getOutput().func_77960_j()));
        }
    }

    private void registerFromFurnace() {
        ConcurrentHashMap smeltingMap = new ConcurrentHashMap(FurnaceRecipes.func_77602_a().func_77599_b());
        for (Map.Entry entry : smeltingMap.entrySet()) {
            if (((ItemStack)entry.getKey()).func_190926_b() || ((ItemStack)entry.getValue()).func_190926_b()) continue;
            int keyMatter = MatterHelper.getMatterAmountFromItem((ItemStack)entry.getKey()) * ((ItemStack)entry.getKey()).func_190916_E() / ((ItemStack)entry.getValue()).func_190916_E();
            int valueMatter = MatterHelper.getMatterAmountFromItem((ItemStack)entry.getValue());
            if (keyMatter <= 0 || valueMatter > 0) continue;
            MatterOverdrive.MATTER_REGISTRY.register(((ItemStack)entry.getValue()).func_77973_b(), new ItemStackHandlerCachable(keyMatter, ((ItemStack)entry.getValue()).func_77960_j()));
        }
    }

    private void debug(String debug, Exception ex, Object ... params) {
        if (MatterOverdrive.MATTER_REGISTRY.CALCULATION_DEBUG) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof ItemStack)) continue;
                try {
                    params[i] = ((ItemStack)params[i]).func_77977_a();
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem getting the name of item %s", ((ItemStack)params[i]).func_77973_b());
                }
            }
            MOLog.log(Level.DEBUG, ex, debug, params);
        }
    }

    private void debug(String debug, Object ... params) {
        if (MatterOverdrive.MATTER_REGISTRY.CALCULATION_DEBUG) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof ItemStack)) continue;
                try {
                    params[i] = ((ItemStack)params[i]).func_77977_a();
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem getting the name of item %s", ((ItemStack)params[i]).func_77973_b());
                }
            }
            MOLog.debug(debug, params);
        }
    }
}

